# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.boolean_value import BooleanValue
from wandelbots_api_client.v2.models.float_value import FloatValue
from wandelbots_api_client.v2.models.integer_value import IntegerValue
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

IOBOUNDARY_ONE_OF_SCHEMAS = ["BooleanValue", "FloatValue", "IntegerValue"]

class IOBoundary(BaseModel):
    """
    IOBoundary
    """
    # data type: BooleanValue
    oneof_schema_1_validator: Optional[BooleanValue] = None
    # data type: IntegerValue
    oneof_schema_2_validator: Optional[IntegerValue] = None
    # data type: FloatValue
    oneof_schema_3_validator: Optional[FloatValue] = None
    actual_instance: Optional[Union[BooleanValue, FloatValue, IntegerValue]] = None
    one_of_schemas: Set[str] = { "BooleanValue", "FloatValue", "IntegerValue" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = IOBoundary.model_construct()
        error_messages = []
        match = 0
        # validate data type: BooleanValue
        if not isinstance(v, BooleanValue):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BooleanValue`")
        else:
            match += 1
        # validate data type: IntegerValue
        if not isinstance(v, IntegerValue):
            error_messages.append(f"Error! Input type `{type(v)}` is not `IntegerValue`")
        else:
            match += 1
        # validate data type: FloatValue
        if not isinstance(v, FloatValue):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FloatValue`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in IOBoundary with oneOf schemas: BooleanValue, FloatValue, IntegerValue. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in IOBoundary with oneOf schemas: BooleanValue, FloatValue, IntegerValue. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("value_type")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `value_type` in the input.")

        # check if data type is `BooleanValue`
        if _data_type == "boolean":
            instance.actual_instance = BooleanValue.from_json(json_str)
            return instance

        # check if data type is `FloatValue`
        if _data_type == "float":
            instance.actual_instance = FloatValue.from_json(json_str)
            return instance

        # check if data type is `IntegerValue`
        if _data_type == "integer":
            instance.actual_instance = IntegerValue.from_json(json_str)
            return instance

        # check if data type is `BooleanValue`
        if _data_type == "BooleanValue":
            instance.actual_instance = BooleanValue.from_json(json_str)
            return instance

        # check if data type is `FloatValue`
        if _data_type == "FloatValue":
            instance.actual_instance = FloatValue.from_json(json_str)
            return instance

        # check if data type is `IntegerValue`
        if _data_type == "IntegerValue":
            instance.actual_instance = IntegerValue.from_json(json_str)
            return instance

        # deserialize data into BooleanValue
        try:
            instance.actual_instance = BooleanValue.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into IntegerValue
        try:
            instance.actual_instance = IntegerValue.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FloatValue
        try:
            instance.actual_instance = FloatValue.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into IOBoundary with oneOf schemas: BooleanValue, FloatValue, IntegerValue. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into IOBoundary with oneOf schemas: BooleanValue, FloatValue, IntegerValue. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], BooleanValue, FloatValue, IntegerValue]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


