# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from wandelbots_api_client.v2.models.modbus_io_area import ModbusIOArea
from wandelbots_api_client.v2.models.modbus_io_byte_order import ModbusIOByteOrder
from wandelbots_api_client.v2.models.modbus_io_type_enum import ModbusIOTypeEnum
from typing import Optional, Set
from typing_extensions import Self

class ModbusIO(BaseModel):
    """
    ModbusIO
    """ # noqa: E501
    description: StrictStr = Field(description="Descriptive name or note for the input/output variable. ") 
    address: Annotated[int, Field(strict=True, ge=0)] = Field(description="The byte address of the input/output variable in the MODBUS device, e.g., NOVA's MODBUS service. Used to locate the input/output variable within the device's memory or data structure. ") 
    type: ModbusIOTypeEnum 
    byte_order: ModbusIOByteOrder = Field(description="The byte sequence of the input/output variable, indicating the order of bytes in memory for the MODBUS device, e.g., NOVA's MODBUS service. ") 
    area: ModbusIOArea = Field(description="The area of the input/output variable, indicating the memory region it belongs to for the MODBUS device, e.g., NOVA's MODBUS service. ") 
    io: StrictStr = Field(description="The unique identifier for the input/output value. Used to reference the input/output variable in the MODBUS device, e.g., NOVA's MODBUS service. ") 
    __properties: ClassVar[List[str]] = ["description", "address", "type", "byte_order", "area", "io"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModbusIO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModbusIO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "address": obj.get("address"),
            "type": obj.get("type"),
            "byte_order": obj.get("byte_order"),
            "area": obj.get("area"),
            "io": obj.get("io")
        })
        return _obj


