# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.collision_setup import CollisionSetup
from wandelbots_api_client.v2.models.limit_set import LimitSet
from wandelbots_api_client.v2.models.payload import Payload
from wandelbots_api_client.v2.models.pose import Pose
from typing import Optional, Set
from typing_extensions import Self

class MotionGroupSetup(BaseModel):
    """
    MotionGroupSetup
    """ # noqa: E501
    motion_group_model: StrictStr = Field(description="String identifiying the model of a motion group.") 
    cycle_time: StrictInt = Field(description="[ms] cycle time of the motion group controller. A trajectory for this motion group should be computed to this resolution.") 
    mounting: Optional[Pose] = Field(default=None, description="The offset from the world frame to the motion group base.") 
    tcp_offset: Optional[Pose] = None 
    global_limits: Optional[LimitSet] = None 
    payload: Optional[Payload] = None 
    collision_setups: Optional[Dict[str, CollisionSetup]] = Field(default=None, description="Collision layers to be respected by the motion planner when planning for a single motion group. Each setup represents one layer, e.g., the safety zones and shapes or a fine grained tool and workpiece model. Layers are checked individually along the trajectory and independently of other layers.  To respect the safety zones of the controller and check for collision: 1. Fetch the safety zones, link and tool shapes from the controller. 2. Add the fetched zones, links and tools to a layer. 3. Create other layers from your own 3D data as needed. 4. Plan trajectory. 5. The response highlights the layer in which a collision was detected by key. ") 
    __properties: ClassVar[List[str]] = ["motion_group_model", "cycle_time", "mounting", "tcp_offset", "global_limits", "payload", "collision_setups"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MotionGroupSetup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of mounting
        if self.mounting:
            _dict['mounting'] = self.mounting.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tcp_offset
        if self.tcp_offset:
            _dict['tcp_offset'] = self.tcp_offset.to_dict()
        # override the default output from pydantic by calling `to_dict()` of global_limits
        if self.global_limits:
            _dict['global_limits'] = self.global_limits.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payload
        if self.payload:
            _dict['payload'] = self.payload.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in collision_setups (dict)
        _field_dict = {}
        if self.collision_setups:
            for _key in self.collision_setups:
                if self.collision_setups[_key]:
                    _field_dict[_key] = self.collision_setups[_key].to_dict()
            _dict['collision_setups'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MotionGroupSetup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "motion_group_model": obj.get("motion_group_model"),
            "cycle_time": obj.get("cycle_time"),
            "mounting": Pose.from_dict(obj["mounting"]) if obj.get("mounting") is not None else None,
            "tcp_offset": Pose.from_dict(obj["tcp_offset"]) if obj.get("tcp_offset") is not None else None,
            "global_limits": LimitSet.from_dict(obj["global_limits"]) if obj.get("global_limits") is not None else None,
            "payload": Payload.from_dict(obj["payload"]) if obj.get("payload") is not None else None,
            "collision_setups": dict(
                (_k, CollisionSetup.from_dict(_v))
                for _k, _v in obj["collision_setups"].items()
            )
            if obj.get("collision_setups") is not None
            else None
        })
        return _obj


