# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class RRTConnectAlgorithm(BaseModel):
    """
    RRTConnectAlgorithm
    """ # noqa: E501
    algorithm_name: str = "RRTConnectAlgorithm"
    max_iterations: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=10000, description="Maximum number of iterations for the RRT Connect algorithm. Higher values increase likelihood of success, but also computation time. ") 
    max_step_size: Optional[Union[StrictFloat, StrictInt]] = Field(default=1, description="Maximum step size for tree extension in joint space.") 
    adaptive_step_size: Optional[StrictBool] = Field(default=True, description="Adjust the maximum step size during the search based on the recent success rate of tree expansion.") 
    apply_smoothing: Optional[StrictBool] = Field(default=True, description="Apply smoothing after the search has succeeded. This will remove as many intermediate points as possible while keeping the path valid.") 
    apply_blending: Optional[StrictBool] = Field(default=True, description="Apply blending after the search has succeeded and smoothing has been applied. This will apply the largest viable blending at each intermediate point.") 
    __properties: ClassVar[List[str]] = ["algorithm_name", "max_iterations", "max_step_size", "adaptive_step_size", "apply_smoothing", "apply_blending"]

    @field_validator('algorithm_name')
    def algorithm_name_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['RRTConnectAlgorithm']):
            raise ValueError("must be one of enum values ('RRTConnectAlgorithm')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RRTConnectAlgorithm from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RRTConnectAlgorithm from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "algorithm_name": obj.get("algorithm_name"),
            "max_iterations": obj.get("max_iterations") if obj.get("max_iterations") is not None else 10000,
            "max_step_size": obj.get("max_step_size") if obj.get("max_step_size") is not None else 1,
            "adaptive_step_size": obj.get("adaptive_step_size") if obj.get("adaptive_step_size") is not None else True,
            "apply_smoothing": obj.get("apply_smoothing") if obj.get("apply_smoothing") is not None else True,
            "apply_blending": obj.get("apply_blending") if obj.get("apply_blending") is not None else True
        })
        return _obj


