# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Union
from wandelbots_api_client.v2.models.trajectory_details_state import TrajectoryDetailsState
from typing import Optional, Set
from typing_extensions import Self

class TrajectoryDetails(BaseModel):
    """
    State of trajectory execution. This state is sent during trajectory movement, response-rate closest to the nearest multiple of controller step-rate but not exceeding the configured rate. The trajectory state can be one of the following: - RUNNING: Trajectory is being executed. - PAUSED_BY_USER: User has paused execution. - END_OF_TRAJECTORY: First or last sample (depending on direction) of trajectory has been sent. - WAIT_FOR_IO: Waiting for an I/O event to start execution. - PAUSED_ON_IO: Execution was paused because of an I/O event. 
    """ # noqa: E501
    trajectory: StrictStr = Field(description="Unique identifier of the trajectory being executed. ") 
    location: Union[StrictFloat, StrictInt] = Field(description="Location on trajectory where the execution will start. The default value is the start (forward movement) or end (backward movement) of the trajectory. If you want to start your movement from an arbitrary location, e.g., in combination with [streamMoveToTrajectoryViaJointPTP](streamMoveToTrajectoryViaJointPTP), set the location by respecting the following format: - The location is a scalar value that defines a position along a path, typically ranging from 0 to `n`,   where `n` denotes the number of motion commands - Each integer value of the location corresponds to a specific motion command,   while non-integer values interpolate positions within the segments. - The location is calculated from the joint path ") 
    state: TrajectoryDetailsState 
    kind: str = "TRAJECTORY"
    __properties: ClassVar[List[str]] = ["trajectory", "location", "state", "kind"]

    @field_validator('kind')
    def kind_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['TRAJECTORY']):
            raise ValueError("must be one of enum values ('TRAJECTORY')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TrajectoryDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict['state'] = self.state.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TrajectoryDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "trajectory": obj.get("trajectory"),
            "location": obj.get("location"),
            "state": TrajectoryDetailsState.from_dict(obj["state"]) if obj.get("state") is not None else None,
            "kind": obj.get("kind")
        })
        return _obj


