# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from wandelbots_api_client.models.robot_controller_state import RobotControllerState
from typing import Optional, Set
from typing_extensions import Self

class JoggingResponse(BaseModel):
    """
    A response for a Jogging Request, is streamed during an active Jogging Movement.
    """ # noqa: E501
    motion_group: StrictStr = Field(description="Identifier of the motion group.") 
    state: RobotControllerState 
    movement_state: StrictStr = Field(description="State of the current movement, e.g. ongoing or stopped due to a particular reason.") 
    __properties: ClassVar[List[str]] = ["motion_group", "state", "movement_state"]

    @field_validator('movement_state')
    def movement_state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['MOVEMENT_STATE_UNKNOWN', 'MOVEMENT_STATE_ERROR', 'MOVEMENT_STATE_MOVING', 'MOVEMENT_STATE_STOP_BY_REQUEST', 'MOVEMENT_STATE_JOINT_LIMIT_REACHED', 'MOVEMENT_STATE_STOP_FOR_IO', 'MOVEMENT_STATE_STOP_FOR_FORCE_LIMIT']):
            raise ValueError("must be one of enum values ('MOVEMENT_STATE_UNKNOWN', 'MOVEMENT_STATE_ERROR', 'MOVEMENT_STATE_MOVING', 'MOVEMENT_STATE_STOP_BY_REQUEST', 'MOVEMENT_STATE_JOINT_LIMIT_REACHED', 'MOVEMENT_STATE_STOP_FOR_IO', 'MOVEMENT_STATE_STOP_FOR_FORCE_LIMIT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JoggingResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict['state'] = self.state.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JoggingResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "motion_group": obj.get("motion_group"),
            "state": RobotControllerState.from_dict(obj["state"]) if obj.get("state") is not None else None,
            "movement_state": obj.get("movement_state")
        })
        return _obj


