# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.models.plan_failed_on_trajectory_response import PlanFailedOnTrajectoryResponse
from wandelbots_api_client.models.plan_failed_response import PlanFailedResponse
from wandelbots_api_client.models.plan_successful_response import PlanSuccessfulResponse
from typing import Optional, Set
from typing_extensions import Self

class PlanResponse(BaseModel):
    """
    -| The plan response signals if the planned motion is executable, partially executable or not executable. If the motion is executable or partially executable, the response contains an unique identifier for the motion and the end joint position. To execute the motion use the unique identifier for calling move endpoints [streamMoveForward](streamMoveForward) or [streamMoveBackward](streamMoveBackward). Use the unique identifier within the endpoints [getMotionTrajectory](getMotionTrajectory) and [getMotionTrajectorySample](getMotionTrajectorySample) to retrieve information about the motion. Use the end joint position to plan and concatenate the next motion. If an error occurred, the response contains feedback including the reason for failure and the location where the failure occurred.
    """ # noqa: E501
    plan_successful_response: Optional[PlanSuccessfulResponse] = None 
    plan_failed_on_trajectory_response: Optional[PlanFailedOnTrajectoryResponse] = None 
    plan_failed_response: Optional[PlanFailedResponse] = None 
    __properties: ClassVar[List[str]] = ["plan_successful_response", "plan_failed_on_trajectory_response", "plan_failed_response"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlanResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of plan_successful_response
        if self.plan_successful_response:
            _dict['plan_successful_response'] = self.plan_successful_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan_failed_on_trajectory_response
        if self.plan_failed_on_trajectory_response:
            _dict['plan_failed_on_trajectory_response'] = self.plan_failed_on_trajectory_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan_failed_response
        if self.plan_failed_response:
            _dict['plan_failed_response'] = self.plan_failed_response.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlanResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "plan_successful_response": PlanSuccessfulResponse.from_dict(obj["plan_successful_response"]) if obj.get("plan_successful_response") is not None else None,
            "plan_failed_on_trajectory_response": PlanFailedOnTrajectoryResponse.from_dict(obj["plan_failed_on_trajectory_response"]) if obj.get("plan_failed_on_trajectory_response") is not None else None,
            "plan_failed_response": PlanFailedResponse.from_dict(obj["plan_failed_response"]) if obj.get("plan_failed_response") is not None else None
        })
        return _obj


