# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.models.abb_controller import AbbController
from wandelbots_api_client.models.fanuc_controller import FanucController
from wandelbots_api_client.models.kuka_controller import KukaController
from wandelbots_api_client.models.universalrobots_controller import UniversalrobotsController
from wandelbots_api_client.models.virtual_controller import VirtualController
from wandelbots_api_client.models.yaskawa_controller import YaskawaController
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ROBOTCONTROLLERCONFIGURATION_ONE_OF_SCHEMAS = ["AbbController", "FanucController", "KukaController", "UniversalrobotsController", "VirtualController", "YaskawaController"]

class RobotControllerConfiguration(BaseModel):
    """
    RobotControllerConfiguration
    """
    # data type: AbbController
    oneof_schema_1_validator: Optional[AbbController] = None
    # data type: FanucController
    oneof_schema_2_validator: Optional[FanucController] = None
    # data type: KukaController
    oneof_schema_3_validator: Optional[KukaController] = None
    # data type: UniversalrobotsController
    oneof_schema_4_validator: Optional[UniversalrobotsController] = None
    # data type: VirtualController
    oneof_schema_5_validator: Optional[VirtualController] = None
    # data type: YaskawaController
    oneof_schema_6_validator: Optional[YaskawaController] = None
    actual_instance: Optional[Union[AbbController, FanucController, KukaController, UniversalrobotsController, VirtualController, YaskawaController]] = None
    one_of_schemas: Set[str] = { "AbbController", "FanucController", "KukaController", "UniversalrobotsController", "VirtualController", "YaskawaController" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = RobotControllerConfiguration.model_construct()
        error_messages = []
        match = 0
        # validate data type: AbbController
        if not isinstance(v, AbbController):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AbbController`")
        else:
            match += 1
        # validate data type: FanucController
        if not isinstance(v, FanucController):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FanucController`")
        else:
            match += 1
        # validate data type: KukaController
        if not isinstance(v, KukaController):
            error_messages.append(f"Error! Input type `{type(v)}` is not `KukaController`")
        else:
            match += 1
        # validate data type: UniversalrobotsController
        if not isinstance(v, UniversalrobotsController):
            error_messages.append(f"Error! Input type `{type(v)}` is not `UniversalrobotsController`")
        else:
            match += 1
        # validate data type: VirtualController
        if not isinstance(v, VirtualController):
            error_messages.append(f"Error! Input type `{type(v)}` is not `VirtualController`")
        else:
            match += 1
        # validate data type: YaskawaController
        if not isinstance(v, YaskawaController):
            error_messages.append(f"Error! Input type `{type(v)}` is not `YaskawaController`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in RobotControllerConfiguration with oneOf schemas: AbbController, FanucController, KukaController, UniversalrobotsController, VirtualController, YaskawaController. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in RobotControllerConfiguration with oneOf schemas: AbbController, FanucController, KukaController, UniversalrobotsController, VirtualController, YaskawaController. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("kind")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `kind` in the input.")

        # check if data type is `AbbController`
        if _data_type == "AbbController":
            instance.actual_instance = AbbController.from_json(json_str)
            return instance

        # check if data type is `FanucController`
        if _data_type == "FanucController":
            instance.actual_instance = FanucController.from_json(json_str)
            return instance

        # check if data type is `KukaController`
        if _data_type == "KukaController":
            instance.actual_instance = KukaController.from_json(json_str)
            return instance

        # check if data type is `UniversalrobotsController`
        if _data_type == "UniversalrobotsController":
            instance.actual_instance = UniversalrobotsController.from_json(json_str)
            return instance

        # check if data type is `VirtualController`
        if _data_type == "VirtualController":
            instance.actual_instance = VirtualController.from_json(json_str)
            return instance

        # check if data type is `YaskawaController`
        if _data_type == "YaskawaController":
            instance.actual_instance = YaskawaController.from_json(json_str)
            return instance

        # deserialize data into AbbController
        try:
            instance.actual_instance = AbbController.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FanucController
        try:
            instance.actual_instance = FanucController.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into KukaController
        try:
            instance.actual_instance = KukaController.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into UniversalrobotsController
        try:
            instance.actual_instance = UniversalrobotsController.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into VirtualController
        try:
            instance.actual_instance = VirtualController.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into YaskawaController
        try:
            instance.actual_instance = YaskawaController.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into RobotControllerConfiguration with oneOf schemas: AbbController, FanucController, KukaController, UniversalrobotsController, VirtualController, YaskawaController. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into RobotControllerConfiguration with oneOf schemas: AbbController, FanucController, KukaController, UniversalrobotsController, VirtualController, YaskawaController. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], AbbController, FanucController, KukaController, UniversalrobotsController, VirtualController, YaskawaController]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


