# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from furl import furl
import json
import humps
import re
import warnings
import websockets
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, AsyncGenerator, Callable, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated
from urllib.parse import quote

from pydantic import Field, StrictStr
from typing_extensions import Annotated
from wandelbots_api_client.v2.models.execute_trajectory_request import ExecuteTrajectoryRequest
from wandelbots_api_client.v2.models.execute_trajectory_response import ExecuteTrajectoryResponse

from wandelbots_api_client.v2.api_client import ApiClient, RequestSerialized
from wandelbots_api_client.v2.api_response import ApiResponse
from wandelbots_api_client.v2.rest import RESTResponseType

class TrajectoryExecutionApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    async def execute_trajectory(self, cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")], controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")], client_request_generator: Callable[[AsyncGenerator[ExecuteTrajectoryResponse, None]], AsyncGenerator[ExecuteTrajectoryRequest, None]]) -> None:  # noqa: E501
        """Execute Trajectory  # noqa: E501

        <!-- theme: success -->  > Websocket endpoint  Provides execution control over a previously [planned trajectory](planTrajectory). Enables the caller to attach input/output actions to the trajectory.  ### Movement behavior  | Virtual controller | Physical controller | |------------------|-------------------| | Desired joint configurations are commanded to each motion group and **applied immediately** | Move to desired **actual joint configuration**, **if possible** |  ### Concept of location    - The location or path parameter specifies the exact position along a trajectory.   - The location is a scalar value that ranges from 0 to `n`, where `n` denotes the number of motion commands, or trajectory segments, e.g., line, p2p, etc. See [planTrajectory](planTrajectory).   - Each integer value of the location corresponds to one motion command, e.g., 3.0 to 3.999 could be a line.  ### Preconditions  - The motion group's control mode is not claimed by any other endpoint. - The motion group's joint position are at start location specified with `InitializeMovementRequest`. - Use [executeToTrajectory](executeToTrajectory) to move the robot to the start location.  ### Requests  #### 1. Send `InitializeMovementRequest` to lock the trajectory to this connection   The following actions are executed:   - Sets robot controller mode to control mode,   - Sets start location of the execution    Keep in mind that only a single trajectory can be locked to a websocket connection at a time and not unlocked anymore.   To execute another trajectory, a new connection must be established.  #### 2. Send `StartMovementRequest` to start the movement  Sets direction of movement, default is forward.  #### **Optional**  - To pause, send `PauseMovementRequest` before the movement has reached its end location. - Change the movement's velocity with `PlaybackSpeedRequest` after initializing the movement with `InitializeMovementRequest`.  ### Responses  - `InitializeMovementResponse` is sent to signal the success or failure of the `InitializeMovementRequest`. - Movement responses are streamed after a `StartMovementRequest` successfully started the movement.   Movement responses are streamed in a rate that is defined as the multiple of the controller step-rate closest to   but not exceeding the rate configured by `InitializeMovementRequest`. - Standstill response is sent once the movement has finished or has come to a standstill due to a pause. - `PauseMovementResponse` is sent to signal the success of the `PauseMovementRequest`. It does not signal the end of the movement.   End of movement is signaled by Standstill response. - `PlaybackSpeedResponse` is sent to signal the success of the `PlaybackSpeedRequest`. - `MovementError` with error details is sent in case of an unexpected error, e.g., controller disconnects during movement.  ### Tips and Tricks  - A movement can be paused and resumed by sending `PauseMovementRequest` and `StartMovementRequest`. - Send `PlaybackSpeedRequest` before `StartMovementRequest` to reduce the velocity of the movement before it starts. - Send `PlaybackSpeedRequest` repeatedly to implement a slider. The velocity of the motion group can be adjusted with each controller step. Therefore, if your app needs a slider-like UI to alter the velocity of a currently running movement, you can send `PlaybackSpeedRequest` with different speed values repeatedly during the movement. - A closed trajectory (end and start joint position are equal) can be repeated by sending `StartMovementRequest` after the movement has finished.   # noqa: E501
        :param client_request_generator: An AsyncGenerator that yields request of type ExecuteTrajectoryRequest and takes an AsyncGenerator of ExecuteTrajectoryResponse as an input argument (required)
        :info All responses from the server will be yielded to client_request_generator through the (AsyncGenerator[ExecuteTrajectoryResponse, None])
        :type AsyncGenerator[ExecuteTrajectoryRequest, None]
        """
        def format_path_parameters(path):
            # Find all substrings that are enclosed in brackets
            bracket_contents = re.findall(r'\{(.*?)\}', path)

            # For each found substring, alter it to match the python variable name
            for content in bracket_contents:
                content = "{" + content + "}"
                modified_content = humps.dekebabize(content)
                path = path.replace(content, modified_content)

            return path

        async def iterate_responses(ws) -> AsyncGenerator[ExecuteTrajectoryResponse, None]:
            async for response in ws:
                if "Cancelled on the server side" in response:
                    break
                response_data = json.loads(response)
                if "result" not in response_data:
                    raise Exception(response_data)
                result_data = response_data["result"]
                if isinstance(result_data, list):
                    # Handle list of objects
                    import re
                    # Extract the base type from List[BaseType] pattern
                    return_type_str = "ExecuteTrajectoryResponse"
                    if return_type_str.startswith("List[") and return_type_str.endswith("]"):
                        base_type_name = return_type_str[5:-1]  # Remove "List[" and "]"
                        # Get the actual class from the module
                        base_type_class = globals().get(base_type_name)
                        if base_type_class and hasattr(base_type_class, 'from_dict'):
                            result_list = [base_type_class.from_dict(item) for item in result_data]
                            yield result_list
                        else:
                            yield result_data
                    else:
                        yield result_data
                else:
                    # Handle single object
                    yield ExecuteTrajectoryResponse.from_dict(result_data)


        path = format_path_parameters("/cells/{cell}/controllers/{controller}/execution/trajectory")
        path = path.format(cell=cell,controller=controller,)

        headers = websockets.Headers()
        tmp_host = self.api_client.configuration.host
        if self.api_client.configuration.host.startswith("https://"):
            # Basic Auth
            if self.api_client.configuration.username:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{self.api_client.configuration.username}:{self.api_client.configuration.password}@{tmp_host}"

            # OAuth2
            elif self.api_client.configuration.access_token:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{tmp_host}"
                headers = websockets.Headers([
                    ("Authorization", f"Bearer {self.api_client.configuration.access_token}")
                ])
        else:
            tmp_host = tmp_host.replace("http://", "ws://")

        full_url = furl(tmp_host + path)

        async with websockets.connect(full_url.url, open_timeout=10, additional_headers=headers) as websocket:
            try:
                async for request in client_request_generator(iterate_responses(websocket)):
                    await websocket.send(request.to_json())
            finally:
                await websocket.close()

