# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.collision_error import CollisionError
from wandelbots_api_client.v2.models.inconsistent_trajectory_size_error import InconsistentTrajectorySizeError
from wandelbots_api_client.v2.models.invalid_dof_error import InvalidDofError
from wandelbots_api_client.v2.models.joint_limit_exceeded_error import JointLimitExceededError
from wandelbots_api_client.v2.models.nan_value_error import NanValueError
from wandelbots_api_client.v2.models.tcp_required_error import TcpRequiredError
from wandelbots_api_client.v2.models.torque_exceeded_error import TorqueExceededError
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ADDTRAJECTORYERRORDATA_ONE_OF_SCHEMAS = ["CollisionError", "InconsistentTrajectorySizeError", "InvalidDofError", "JointLimitExceededError", "NanValueError", "TcpRequiredError", "TorqueExceededError"]

class AddTrajectoryErrorData(BaseModel):
    """
    AddTrajectoryErrorData
    """
    # data type: TcpRequiredError
    oneof_schema_1_validator: Optional[TcpRequiredError] = None
    # data type: InconsistentTrajectorySizeError
    oneof_schema_2_validator: Optional[InconsistentTrajectorySizeError] = None
    # data type: JointLimitExceededError
    oneof_schema_3_validator: Optional[JointLimitExceededError] = None
    # data type: CollisionError
    oneof_schema_4_validator: Optional[CollisionError] = None
    # data type: TorqueExceededError
    oneof_schema_5_validator: Optional[TorqueExceededError] = None
    # data type: InvalidDofError
    oneof_schema_6_validator: Optional[InvalidDofError] = None
    # data type: NanValueError
    oneof_schema_7_validator: Optional[NanValueError] = None
    actual_instance: Optional[Union[CollisionError, InconsistentTrajectorySizeError, InvalidDofError, JointLimitExceededError, NanValueError, TcpRequiredError, TorqueExceededError]] = None
    one_of_schemas: Set[str] = { "CollisionError", "InconsistentTrajectorySizeError", "InvalidDofError", "JointLimitExceededError", "NanValueError", "TcpRequiredError", "TorqueExceededError" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = AddTrajectoryErrorData.model_construct()
        error_messages = []
        match = 0
        # validate data type: TcpRequiredError
        if not isinstance(v, TcpRequiredError):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TcpRequiredError`")
        else:
            match += 1
        # validate data type: InconsistentTrajectorySizeError
        if not isinstance(v, InconsistentTrajectorySizeError):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InconsistentTrajectorySizeError`")
        else:
            match += 1
        # validate data type: JointLimitExceededError
        if not isinstance(v, JointLimitExceededError):
            error_messages.append(f"Error! Input type `{type(v)}` is not `JointLimitExceededError`")
        else:
            match += 1
        # validate data type: CollisionError
        if not isinstance(v, CollisionError):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CollisionError`")
        else:
            match += 1
        # validate data type: TorqueExceededError
        if not isinstance(v, TorqueExceededError):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TorqueExceededError`")
        else:
            match += 1
        # validate data type: InvalidDofError
        if not isinstance(v, InvalidDofError):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InvalidDofError`")
        else:
            match += 1
        # validate data type: NanValueError
        if not isinstance(v, NanValueError):
            error_messages.append(f"Error! Input type `{type(v)}` is not `NanValueError`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in AddTrajectoryErrorData with oneOf schemas: CollisionError, InconsistentTrajectorySizeError, InvalidDofError, JointLimitExceededError, NanValueError, TcpRequiredError, TorqueExceededError. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in AddTrajectoryErrorData with oneOf schemas: CollisionError, InconsistentTrajectorySizeError, InvalidDofError, JointLimitExceededError, NanValueError, TcpRequiredError, TorqueExceededError. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into TcpRequiredError
        try:
            instance.actual_instance = TcpRequiredError.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into InconsistentTrajectorySizeError
        try:
            instance.actual_instance = InconsistentTrajectorySizeError.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into JointLimitExceededError
        try:
            instance.actual_instance = JointLimitExceededError.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CollisionError
        try:
            instance.actual_instance = CollisionError.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TorqueExceededError
        try:
            instance.actual_instance = TorqueExceededError.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into InvalidDofError
        try:
            instance.actual_instance = InvalidDofError.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into NanValueError
        try:
            instance.actual_instance = NanValueError.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into AddTrajectoryErrorData with oneOf schemas: CollisionError, InconsistentTrajectorySizeError, InvalidDofError, JointLimitExceededError, NanValueError, TcpRequiredError, TorqueExceededError. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AddTrajectoryErrorData with oneOf schemas: CollisionError, InconsistentTrajectorySizeError, InvalidDofError, JointLimitExceededError, NanValueError, TcpRequiredError, TorqueExceededError. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], CollisionError, InconsistentTrajectorySizeError, InvalidDofError, JointLimitExceededError, NanValueError, TcpRequiredError, TorqueExceededError]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


