# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.add_trajectory_error import AddTrajectoryError
from typing import Optional, Set
from typing_extensions import Self

class AddTrajectoryResponse(BaseModel):
    """
    The response signals if the trajectory is valid or faulty resulting in an executable, partially executable or not executable state. - valid trajectory: response contains only the unique identifier for the trajectory - trajectory has error on path: response contains the unique identifier for the trajectory and information about the failure. It is executable up to the point of failure. - trajectory has error at start or invalid data: response contains only information about the failure.  To execute the trajectory use the unique identifier for calling [executeTrajectory](executeTrajectory). If you want to validate your trajectory before execution, execute it with a virtual motion group and check the state in the response stream of [executeTrajectory](executeTrajectory). 
    """ # noqa: E501
    trajectory: Optional[StrictStr] = Field(default=None, description="The unique identifier of the trajectory. Use this identifier to execute the trajectory with the [executeTrajectory](executeTrajectory) endpoint. ") 
    error: Optional[AddTrajectoryError] = Field(default=None, description="Always check this field first. If this field is present, the trajectory has an error and is only partially or not executable. ") 
    __properties: ClassVar[List[str]] = ["trajectory", "error"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddTrajectoryResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of error
        if self.error:
            _dict['error'] = self.error.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddTrajectoryResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "trajectory": obj.get("trajectory"),
            "error": AddTrajectoryError.from_dict(obj["error"]) if obj.get("error") is not None else None
        })
        return _obj


