# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class BusIOProfinetIpConfig(BaseModel):
    """
    Network configuration or IPv4 record of the virtual ethernet interface (pnio1) created by the PROFINET driver. The IPv4 record is used in combination with the Name of Station (NoS) to identify your device in the PROFINET network.  The `ip_config` will be used as IPv4 record if no REMA XML file is already present on your machine and no `rema_xml_content` is provided. 
    """ # noqa: E501
    ip: StrictStr = Field(description="IP address for the device's virtual ethernet interface (pnio1).") 
    netmask: StrictStr = Field(description="Network mask for the device's virtual ethernet interface (pnio1).") 
    gateway: StrictStr = Field(description="Gateway for connections to other devices outside of the virtual ethernet interface's subnet.") 
    __properties: ClassVar[List[str]] = ["ip", "netmask", "gateway"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BusIOProfinetIpConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BusIOProfinetIpConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ip": obj.get("ip"),
            "netmask": obj.get("netmask"),
            "gateway": obj.get("gateway")
        })
        return _obj


