# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.bus_io_modbus_client import BusIOModbusClient
from wandelbots_api_client.v2.models.bus_io_modbus_server import BusIOModbusServer
from wandelbots_api_client.v2.models.bus_io_modbus_virtual import BusIOModbusVirtual
from wandelbots_api_client.v2.models.bus_io_profinet import BusIOProfinet
from wandelbots_api_client.v2.models.bus_io_profinet_virtual import BusIOProfinetVirtual
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

BUSIOTYPE_ONE_OF_SCHEMAS = ["BusIOModbusClient", "BusIOModbusServer", "BusIOModbusVirtual", "BusIOProfinet", "BusIOProfinetVirtual"]

class BusIOType(BaseModel):
    """
    BusIOType
    """
    # data type: BusIOProfinet
    oneof_schema_1_validator: Optional[BusIOProfinet] = None
    # data type: BusIOProfinetVirtual
    oneof_schema_2_validator: Optional[BusIOProfinetVirtual] = None
    # data type: BusIOModbusServer
    oneof_schema_3_validator: Optional[BusIOModbusServer] = None
    # data type: BusIOModbusClient
    oneof_schema_4_validator: Optional[BusIOModbusClient] = None
    # data type: BusIOModbusVirtual
    oneof_schema_5_validator: Optional[BusIOModbusVirtual] = None
    actual_instance: Optional[Union[BusIOModbusClient, BusIOModbusServer, BusIOModbusVirtual, BusIOProfinet, BusIOProfinetVirtual]] = None
    one_of_schemas: Set[str] = { "BusIOModbusClient", "BusIOModbusServer", "BusIOModbusVirtual", "BusIOProfinet", "BusIOProfinetVirtual" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = BusIOType.model_construct()
        error_messages = []
        match = 0
        # validate data type: BusIOProfinet
        if not isinstance(v, BusIOProfinet):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BusIOProfinet`")
        else:
            match += 1
        # validate data type: BusIOProfinetVirtual
        if not isinstance(v, BusIOProfinetVirtual):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BusIOProfinetVirtual`")
        else:
            match += 1
        # validate data type: BusIOModbusServer
        if not isinstance(v, BusIOModbusServer):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BusIOModbusServer`")
        else:
            match += 1
        # validate data type: BusIOModbusClient
        if not isinstance(v, BusIOModbusClient):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BusIOModbusClient`")
        else:
            match += 1
        # validate data type: BusIOModbusVirtual
        if not isinstance(v, BusIOModbusVirtual):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BusIOModbusVirtual`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in BusIOType with oneOf schemas: BusIOModbusClient, BusIOModbusServer, BusIOModbusVirtual, BusIOProfinet, BusIOProfinetVirtual. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in BusIOType with oneOf schemas: BusIOModbusClient, BusIOModbusServer, BusIOModbusVirtual, BusIOProfinet, BusIOProfinetVirtual. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("bus_type")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `bus_type` in the input.")

        # check if data type is `BusIOModbusClient`
        if _data_type == "modbus_client":
            instance.actual_instance = BusIOModbusClient.from_json(json_str)
            return instance

        # check if data type is `BusIOModbusServer`
        if _data_type == "modbus_server":
            instance.actual_instance = BusIOModbusServer.from_json(json_str)
            return instance

        # check if data type is `BusIOModbusVirtual`
        if _data_type == "modbus_virtual":
            instance.actual_instance = BusIOModbusVirtual.from_json(json_str)
            return instance

        # check if data type is `BusIOProfinet`
        if _data_type == "profinet":
            instance.actual_instance = BusIOProfinet.from_json(json_str)
            return instance

        # check if data type is `BusIOProfinetVirtual`
        if _data_type == "profinet_virtual":
            instance.actual_instance = BusIOProfinetVirtual.from_json(json_str)
            return instance

        # deserialize data into BusIOProfinet
        try:
            instance.actual_instance = BusIOProfinet.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into BusIOProfinetVirtual
        try:
            instance.actual_instance = BusIOProfinetVirtual.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into BusIOModbusServer
        try:
            instance.actual_instance = BusIOModbusServer.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into BusIOModbusClient
        try:
            instance.actual_instance = BusIOModbusClient.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into BusIOModbusVirtual
        try:
            instance.actual_instance = BusIOModbusVirtual.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into BusIOType with oneOf schemas: BusIOModbusClient, BusIOModbusServer, BusIOModbusVirtual, BusIOProfinet, BusIOProfinetVirtual. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into BusIOType with oneOf schemas: BusIOModbusClient, BusIOModbusServer, BusIOModbusVirtual, BusIOProfinet, BusIOProfinetVirtual. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], BusIOModbusClient, BusIOModbusServer, BusIOModbusVirtual, BusIOProfinet, BusIOProfinetVirtual]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


