# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.midpoint_insertion_algorithm import MidpointInsertionAlgorithm
from wandelbots_api_client.v2.models.rrt_connect_algorithm import RRTConnectAlgorithm
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

COLLISIONFREEALGORITHM_ONE_OF_SCHEMAS = ["MidpointInsertionAlgorithm", "RRTConnectAlgorithm"]

class CollisionFreeAlgorithm(BaseModel):
    """
    Configuration for collision-free path planning algorithms. Different algorithms may have different parameters and behavior.  Recommendation: - For **cells with many obstacles**, use the RRTConnect algorithm. Use it as a starting point. - For **simple cells with very few obstacles** and when a faster solution is needed, try the MidpointInsertion algorithm. 
    """
    # data type: RRTConnectAlgorithm
    oneof_schema_1_validator: Optional[RRTConnectAlgorithm] = None
    # data type: MidpointInsertionAlgorithm
    oneof_schema_2_validator: Optional[MidpointInsertionAlgorithm] = None
    actual_instance: Optional[Union[MidpointInsertionAlgorithm, RRTConnectAlgorithm]] = None
    one_of_schemas: Set[str] = { "MidpointInsertionAlgorithm", "RRTConnectAlgorithm" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = CollisionFreeAlgorithm.model_construct()
        error_messages = []
        match = 0
        # validate data type: RRTConnectAlgorithm
        if not isinstance(v, RRTConnectAlgorithm):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RRTConnectAlgorithm`")
        else:
            match += 1
        # validate data type: MidpointInsertionAlgorithm
        if not isinstance(v, MidpointInsertionAlgorithm):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MidpointInsertionAlgorithm`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in CollisionFreeAlgorithm with oneOf schemas: MidpointInsertionAlgorithm, RRTConnectAlgorithm. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in CollisionFreeAlgorithm with oneOf schemas: MidpointInsertionAlgorithm, RRTConnectAlgorithm. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("algorithm_name")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `algorithm_name` in the input.")

        # check if data type is `MidpointInsertionAlgorithm`
        if _data_type == "MidpointInsertionAlgorithm":
            instance.actual_instance = MidpointInsertionAlgorithm.from_json(json_str)
            return instance

        # check if data type is `RRTConnectAlgorithm`
        if _data_type == "RRTConnectAlgorithm":
            instance.actual_instance = RRTConnectAlgorithm.from_json(json_str)
            return instance

        # deserialize data into RRTConnectAlgorithm
        try:
            instance.actual_instance = RRTConnectAlgorithm.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MidpointInsertionAlgorithm
        try:
            instance.actual_instance = MidpointInsertionAlgorithm.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into CollisionFreeAlgorithm with oneOf schemas: MidpointInsertionAlgorithm, RRTConnectAlgorithm. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into CollisionFreeAlgorithm with oneOf schemas: MidpointInsertionAlgorithm, RRTConnectAlgorithm. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], MidpointInsertionAlgorithm, RRTConnectAlgorithm]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


