# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.initialize_jogging_request import InitializeJoggingRequest
from wandelbots_api_client.v2.models.joint_velocity_request import JointVelocityRequest
from wandelbots_api_client.v2.models.pause_jogging_request import PauseJoggingRequest
from wandelbots_api_client.v2.models.tcp_velocity_request import TcpVelocityRequest
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

EXECUTEJOGGINGREQUEST_ONE_OF_SCHEMAS = ["InitializeJoggingRequest", "JointVelocityRequest", "PauseJoggingRequest", "TcpVelocityRequest"]

class ExecuteJoggingRequest(BaseModel):
    """
    ExecuteJoggingRequest
    """
    # data type: InitializeJoggingRequest
    oneof_schema_1_validator: Optional[InitializeJoggingRequest] = None
    # data type: JointVelocityRequest
    oneof_schema_2_validator: Optional[JointVelocityRequest] = None
    # data type: TcpVelocityRequest
    oneof_schema_3_validator: Optional[TcpVelocityRequest] = None
    # data type: PauseJoggingRequest
    oneof_schema_4_validator: Optional[PauseJoggingRequest] = None
    actual_instance: Optional[Union[InitializeJoggingRequest, JointVelocityRequest, PauseJoggingRequest, TcpVelocityRequest]] = None
    one_of_schemas: Set[str] = { "InitializeJoggingRequest", "JointVelocityRequest", "PauseJoggingRequest", "TcpVelocityRequest" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ExecuteJoggingRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: InitializeJoggingRequest
        if not isinstance(v, InitializeJoggingRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InitializeJoggingRequest`")
        else:
            match += 1
        # validate data type: JointVelocityRequest
        if not isinstance(v, JointVelocityRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `JointVelocityRequest`")
        else:
            match += 1
        # validate data type: TcpVelocityRequest
        if not isinstance(v, TcpVelocityRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TcpVelocityRequest`")
        else:
            match += 1
        # validate data type: PauseJoggingRequest
        if not isinstance(v, PauseJoggingRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PauseJoggingRequest`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ExecuteJoggingRequest with oneOf schemas: InitializeJoggingRequest, JointVelocityRequest, PauseJoggingRequest, TcpVelocityRequest. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ExecuteJoggingRequest with oneOf schemas: InitializeJoggingRequest, JointVelocityRequest, PauseJoggingRequest, TcpVelocityRequest. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("message_type")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `message_type` in the input.")

        # check if data type is `InitializeJoggingRequest`
        if _data_type == "InitializeJoggingRequest":
            instance.actual_instance = InitializeJoggingRequest.from_json(json_str)
            return instance

        # check if data type is `JointVelocityRequest`
        if _data_type == "JointVelocityRequest":
            instance.actual_instance = JointVelocityRequest.from_json(json_str)
            return instance

        # check if data type is `PauseJoggingRequest`
        if _data_type == "PauseJoggingRequest":
            instance.actual_instance = PauseJoggingRequest.from_json(json_str)
            return instance

        # check if data type is `TcpVelocityRequest`
        if _data_type == "TcpVelocityRequest":
            instance.actual_instance = TcpVelocityRequest.from_json(json_str)
            return instance

        # deserialize data into InitializeJoggingRequest
        try:
            instance.actual_instance = InitializeJoggingRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into JointVelocityRequest
        try:
            instance.actual_instance = JointVelocityRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TcpVelocityRequest
        try:
            instance.actual_instance = TcpVelocityRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PauseJoggingRequest
        try:
            instance.actual_instance = PauseJoggingRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ExecuteJoggingRequest with oneOf schemas: InitializeJoggingRequest, JointVelocityRequest, PauseJoggingRequest, TcpVelocityRequest. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ExecuteJoggingRequest with oneOf schemas: InitializeJoggingRequest, JointVelocityRequest, PauseJoggingRequest, TcpVelocityRequest. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], InitializeJoggingRequest, JointVelocityRequest, PauseJoggingRequest, TcpVelocityRequest]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


