# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from wandelbots_api_client.v2.models.pose import Pose
from typing import Optional, Set
from typing_extensions import Self

class ForwardKinematicsRequest(BaseModel):
    """
    ForwardKinematicsRequest
    """ # noqa: E501
    motion_group_model: StrictStr = Field(description="String identifiying the model of a motion group.") 
    joint_positions: List[List[Union[StrictFloat, StrictInt]]] = Field(description="List of joint positions [rad] for which TCP poses are computed. ") 
    tcp_offset: Optional[Pose] = None 
    mounting: Optional[Pose] = Field(default=None, description="Offset from the world frame to the motion group base.") 
    __properties: ClassVar[List[str]] = ["motion_group_model", "joint_positions", "tcp_offset", "mounting"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ForwardKinematicsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tcp_offset
        if self.tcp_offset:
            _dict['tcp_offset'] = self.tcp_offset.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mounting
        if self.mounting:
            _dict['mounting'] = self.mounting.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ForwardKinematicsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "motion_group_model": obj.get("motion_group_model"),
            "joint_positions": obj.get("joint_positions"),
            "tcp_offset": Pose.from_dict(obj["tcp_offset"]) if obj.get("tcp_offset") is not None else None,
            "mounting": Pose.from_dict(obj["mounting"]) if obj.get("mounting") is not None else None
        })
        return _obj


