# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from wandelbots_api_client.v2.models.collider import Collider
from wandelbots_api_client.v2.models.dh_parameter import DHParameter
from wandelbots_api_client.v2.models.operation_limits import OperationLimits
from wandelbots_api_client.v2.models.payload import Payload
from wandelbots_api_client.v2.models.pose import Pose
from wandelbots_api_client.v2.models.tcp_offset import TcpOffset
from typing import Optional, Set
from typing_extensions import Self

class MotionGroupDescription(BaseModel):
    """
    The configuration of a motion-group used for motion planning.
    """ # noqa: E501
    motion_group_model: StrictStr = Field(description="String identifiying the model of a motion group.") 
    mounting: Optional[Pose] = Field(default=None, description="The offset from the world frame to the motion group base.") 
    tcps: Optional[Dict[str, TcpOffset]] = Field(default=None, description="Maps a TCP name to its offset relative to the flange coordinate system. Key must be a TCP identifier. Values are TcpOffsets. ") 
    safety_zones: Optional[Dict[str, Collider]] = Field(default=None, description="A collection of identifiable colliders.") 
    safety_link_colliders: Optional[List[Dict[str, Collider]]] = Field(default=None, description="The shape of the MotionGroups links to validate against safety zones. Indexed along the kinematic chain, starting with a static base shape before first joint. ") 
    safety_tool_colliders: Optional[Dict[str, Dict[str, Collider]]] = Field(default=None, description="Maps a TCP name to its tool collider. Key must be a TCP identifier. Values are ColliderDictionaries that make up the shape of one tool to validate against safety zones. ") 
    operation_limits: OperationLimits 
    payloads: Optional[Dict[str, Payload]] = Field(default=None, description="Maps a payload name to its configuration. Key must be a payload identifier. Values are payload objects. ") 
    cycle_time: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=0)]] = Field(default=None, description="[ms] cycle time of the motion group controller. A trajectory for this motion group should be computed to this resolution.") 
    dh_parameters: Optional[List[DHParameter]] = Field(default=None, description="The DH parameters describing the motion group geometry, starting from base.") 
    serial_number: Optional[StrictStr] = Field(default=None, description="The serial number of the motion group, if available. If not available, the serial number of the robot controller. If not available, empty. ") 
    __properties: ClassVar[List[str]] = ["motion_group_model", "mounting", "tcps", "safety_zones", "safety_link_colliders", "safety_tool_colliders", "operation_limits", "payloads", "cycle_time", "dh_parameters", "serial_number"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MotionGroupDescription from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of mounting
        if self.mounting:
            _dict['mounting'] = self.mounting.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in tcps (dict)
        # >>> Modified from openapi template
        if self.tcps:
            _field_dict = {}
            for _key, _value in self.tcps.items():
                if self.tcps[_key]:
                    _field_dict[_key] = _value.to_dict()
            _dict['tcps'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in safety_zones (dict)
        # >>> Modified from openapi template
        if self.safety_zones:
            _field_dict = {}
            for _key, _value in self.safety_zones.items():
                if self.safety_zones[_key]:
                    _field_dict[_key] = _value.to_dict()
            _dict['safety_zones'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in safety_link_colliders (list)
        _items = []
        if self.safety_link_colliders:
            for _item in self.safety_link_colliders:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                _items.append({key: value.to_dict() for key, value in _item.items()})
                # <<< End modification
            _dict['safety_link_colliders'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in safety_tool_colliders (dict)
        # >>> Modified from openapi template
        if self.safety_tool_colliders:
            _field_dict = {}
            for _key, _value in self.safety_tool_colliders.items():
                if self.safety_tool_colliders[_key]:
                    _field_dict[_key] = {_nested_key: _nested_value.to_dict() for _nested_key, _nested_value in _value.items()}
            _dict['safety_tool_colliders'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of operation_limits
        if self.operation_limits:
            _dict['operation_limits'] = self.operation_limits.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in payloads (dict)
        # >>> Modified from openapi template
        if self.payloads:
            _field_dict = {}
            for _key, _value in self.payloads.items():
                if self.payloads[_key]:
                    _field_dict[_key] = _value.to_dict()
            _dict['payloads'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in dh_parameters (list)
        _items = []
        if self.dh_parameters:
            for _item in self.dh_parameters:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['dh_parameters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MotionGroupDescription from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "motion_group_model": obj.get("motion_group_model"),
            "mounting": Pose.from_dict(obj["mounting"]) if obj.get("mounting") is not None else None,
            "tcps": dict(
                (_k, TcpOffset.from_dict(_v))
                for _k, _v in obj["tcps"].items()
            )
            if obj.get("tcps") is not None
            else None,
            "safety_zones": dict(
                (_k, Collider.from_dict(_v))
                for _k, _v in obj["safety_zones"].items()
            )
            if obj.get("safety_zones") is not None
            else None,
            "safety_link_colliders": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                {key: Collider.from_dict(value) for key, value in _item.items()} if isinstance(_item, dict) else _item
                # <<< End modification
                for _item in obj["safety_link_colliders"]
            ] if obj.get("safety_link_colliders") is not None else None,
            "safety_tool_colliders": dict(
                (_k, dict(
                    (_ik, Collider.from_dict(_iv))
                        for _ik, _iv in _v.items()
                    )
                    if _v is not None
                    else None
                )
                for _k, _v in obj.get("safety_tool_colliders").items()
            )
            if obj.get("safety_tool_colliders") is not None
            else None,
            "operation_limits": OperationLimits.from_dict(obj["operation_limits"]) if obj.get("operation_limits") is not None else None,
            "payloads": dict(
                (_k, Payload.from_dict(_v))
                for _k, _v in obj["payloads"].items()
            )
            if obj.get("payloads") is not None
            else None,
            "cycle_time": obj.get("cycle_time"),
            "dh_parameters": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                DHParameter.from_dict(_item) if hasattr(DHParameter, 'from_dict') else _item
                # <<< End modification
                for _item in obj["dh_parameters"]
            ] if obj.get("dh_parameters") is not None else None,
            "serial_number": obj.get("serial_number")
        })
        return _obj


