# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.limit_set import LimitSet
from typing import Optional, Set
from typing_extensions import Self

class OperationLimits(BaseModel):
    """
    OperationLimits
    """ # noqa: E501
    auto_limits: Optional[LimitSet] = None 
    manual_limits: Optional[LimitSet] = None 
    manual_t1_limits: Optional[LimitSet] = None 
    manual_t2_limits: Optional[LimitSet] = None 
    __properties: ClassVar[List[str]] = ["auto_limits", "manual_limits", "manual_t1_limits", "manual_t2_limits"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OperationLimits from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of auto_limits
        if self.auto_limits:
            _dict['auto_limits'] = self.auto_limits.to_dict()
        # override the default output from pydantic by calling `to_dict()` of manual_limits
        if self.manual_limits:
            _dict['manual_limits'] = self.manual_limits.to_dict()
        # override the default output from pydantic by calling `to_dict()` of manual_t1_limits
        if self.manual_t1_limits:
            _dict['manual_t1_limits'] = self.manual_t1_limits.to_dict()
        # override the default output from pydantic by calling `to_dict()` of manual_t2_limits
        if self.manual_t2_limits:
            _dict['manual_t2_limits'] = self.manual_t2_limits.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OperationLimits from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "auto_limits": LimitSet.from_dict(obj["auto_limits"]) if obj.get("auto_limits") is not None else None,
            "manual_limits": LimitSet.from_dict(obj["manual_limits"]) if obj.get("manual_limits") is not None else None,
            "manual_t1_limits": LimitSet.from_dict(obj["manual_t1_limits"]) if obj.get("manual_t1_limits") is not None else None,
            "manual_t2_limits": LimitSet.from_dict(obj["manual_t2_limits"]) if obj.get("manual_t2_limits") is not None else None
        })
        return _obj


