# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.error_invalid_joint_count import ErrorInvalidJointCount
from wandelbots_api_client.v2.models.error_joint_limit_exceeded import ErrorJointLimitExceeded
from wandelbots_api_client.v2.models.error_joint_position_collision import ErrorJointPositionCollision
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

PLANVALIDATIONERRORALLOFDATA_ONE_OF_SCHEMAS = ["ErrorInvalidJointCount", "ErrorJointLimitExceeded", "ErrorJointPositionCollision"]

class PlanValidationErrorAllOfData(BaseModel):
    """
    Optional data further specifying the validation error. 
    """
    # data type: ErrorInvalidJointCount
    oneof_schema_1_validator: Optional[ErrorInvalidJointCount] = None
    # data type: ErrorJointLimitExceeded
    oneof_schema_2_validator: Optional[ErrorJointLimitExceeded] = None
    # data type: ErrorJointPositionCollision
    oneof_schema_3_validator: Optional[ErrorJointPositionCollision] = None
    actual_instance: Optional[Union[ErrorInvalidJointCount, ErrorJointLimitExceeded, ErrorJointPositionCollision]] = None
    one_of_schemas: Set[str] = { "ErrorInvalidJointCount", "ErrorJointLimitExceeded", "ErrorJointPositionCollision" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = PlanValidationErrorAllOfData.model_construct()
        error_messages = []
        match = 0
        # validate data type: ErrorInvalidJointCount
        if not isinstance(v, ErrorInvalidJointCount):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ErrorInvalidJointCount`")
        else:
            match += 1
        # validate data type: ErrorJointLimitExceeded
        if not isinstance(v, ErrorJointLimitExceeded):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ErrorJointLimitExceeded`")
        else:
            match += 1
        # validate data type: ErrorJointPositionCollision
        if not isinstance(v, ErrorJointPositionCollision):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ErrorJointPositionCollision`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in PlanValidationErrorAllOfData with oneOf schemas: ErrorInvalidJointCount, ErrorJointLimitExceeded, ErrorJointPositionCollision. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in PlanValidationErrorAllOfData with oneOf schemas: ErrorInvalidJointCount, ErrorJointLimitExceeded, ErrorJointPositionCollision. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("error_feedback_name")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `error_feedback_name` in the input.")

        # check if data type is `ErrorInvalidJointCount`
        if _data_type == "ErrorInvalidJointCount":
            instance.actual_instance = ErrorInvalidJointCount.from_json(json_str)
            return instance

        # check if data type is `ErrorJointLimitExceeded`
        if _data_type == "ErrorJointLimitExceeded":
            instance.actual_instance = ErrorJointLimitExceeded.from_json(json_str)
            return instance

        # check if data type is `ErrorJointPositionCollision`
        if _data_type == "ErrorJointPositionCollision":
            instance.actual_instance = ErrorJointPositionCollision.from_json(json_str)
            return instance

        # deserialize data into ErrorInvalidJointCount
        try:
            instance.actual_instance = ErrorInvalidJointCount.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ErrorJointLimitExceeded
        try:
            instance.actual_instance = ErrorJointLimitExceeded.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ErrorJointPositionCollision
        try:
            instance.actual_instance = ErrorJointPositionCollision.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into PlanValidationErrorAllOfData with oneOf schemas: ErrorInvalidJointCount, ErrorJointLimitExceeded, ErrorJointPositionCollision. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into PlanValidationErrorAllOfData with oneOf schemas: ErrorInvalidJointCount, ErrorJointLimitExceeded, ErrorJointPositionCollision. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ErrorInvalidJointCount, ErrorJointLimitExceeded, ErrorJointPositionCollision]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


