# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from wandelbots_api_client.v2.models.motion_group_state import MotionGroupState
from wandelbots_api_client.v2.models.operation_mode import OperationMode
from wandelbots_api_client.v2.models.robot_system_mode import RobotSystemMode
from wandelbots_api_client.v2.models.safety_state_type import SafetyStateType
from typing import Optional, Set
from typing_extensions import Self

class RobotControllerState(BaseModel):
    """
    Returns the whole current state of robot controller.
    """ # noqa: E501
    mode: RobotSystemMode = Field(description="Mode of communication and control between NOVA and the robot controller.") 
    last_error: Optional[List[StrictStr]] = Field(default=None, description="Last error stack encountered during initialization process or after a controller disconnect. At this stage, it's unclear whether the error is fatal.  Evaluate `last_error` to decide whether to remove the controller using `deleteController`. Examples: - Delete required: Host resolution fails repeatedly due to an incorrect IP. - Delete not required: Temporary network delay caused a disconnect; the system will auto-reconnect. ") 
    timestamp: datetime = Field(description="Timestamp indicating when the represented information was received from the robot controller.") 
    sequence_number: Annotated[int, Field(le=4294967295, strict=True, ge=0)] = Field(description="Sequence number of the controller state. It starts with 0 upon establishing the connection with a physical controller. The sequence number is reset when the connection to the physical controller is closed and re-established. ") 
    controller: StrictStr = Field(description="Identifier of the configured robot controller.") 
    operation_mode: OperationMode 
    safety_state: SafetyStateType 
    velocity_override: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = Field(default=None, description="If made available by the robot controller, returns the current velocity override in [percentage] for movements adjusted on robot control panel. Valid value range: 1 - 100. ") 
    motion_groups: List[MotionGroupState] = Field(description="State of indicated motion groups. In case of state request via controller all configured motion groups are returned. In case of executing a motion only the affected motion groups are returned. ") 
    __properties: ClassVar[List[str]] = ["mode", "last_error", "timestamp", "sequence_number", "controller", "operation_mode", "safety_state", "velocity_override", "motion_groups"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RobotControllerState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in motion_groups (list)
        _items = []
        if self.motion_groups:
            for _item in self.motion_groups:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['motion_groups'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RobotControllerState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "mode": obj.get("mode"),
            "last_error": obj.get("last_error"),
            "timestamp": obj.get("timestamp"),
            "sequence_number": obj.get("sequence_number"),
            "controller": obj.get("controller") if obj.get("controller") is not None else 'controller',
            "operation_mode": obj.get("operation_mode"),
            "safety_state": obj.get("safety_state"),
            "velocity_override": obj.get("velocity_override"),
            "motion_groups": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                MotionGroupState.from_dict(_item) if hasattr(MotionGroupState, 'from_dict') else _item
                # <<< End modification
                for _item in obj["motion_groups"]
            ] if obj.get("motion_groups") is not None else None
        })
        return _obj


