# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.1.0 dev
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class RobotSystemMode(str, Enum):
    """
    Defines the current system mode of the robot system, including NOVA communicating with the robot controller.  ### MODE_CONTROLLER_NOT_CONFIGURED  No controller with the specified identifier is configured. Call [addRobotController](addRobotController) to register a controller.  ### MODE_INITIALIZING  Indicates that a connection to the robot controller is established or reestablished in case of a disconnect. On success, the controller is set to MODE_MONITOR. On failure, the initialization process is retried until successful or cancelled by the user.  ### MODE_MONITOR  Read-only mode with an active controller connection. - Receives robot state and I/O signals - Move requests are rejected - No commands are sent to the controller  ### MODE_CONTROL  Active control mode.  **Movement is possible in this mode**  The robot is cyclically commanded to hold its current position. The robot state is received in sync with the controller cycle. Motion and jogging requests are accepted and executed. Input/Output interaction is enabled.  ### MODE_FREE_DRIVE  Read-only mode with servo motors enabled for manual movement (Free Drive).  Move requests are rejected.  Not supported by all robots: Use [getSupportedModes](getSupportedModes) to check Free Drive availability. 
    """

    """
    allowed enum values
    """
    MODE_CONTROLLER_NOT_CONFIGURED = 'MODE_CONTROLLER_NOT_CONFIGURED'
    MODE_INITIALIZING = 'MODE_INITIALIZING'
    MODE_MONITOR = 'MODE_MONITOR'
    MODE_CONTROL = 'MODE_CONTROL'
    MODE_FREE_DRIVE = 'MODE_FREE_DRIVE'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of RobotSystemMode from a JSON string"""
        return cls(json.loads(json_str))


