# coding: utf-8

"""
    Wandelbots Nova API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from furl import furl
import json
import humps
import re
import warnings
import websockets
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, AsyncGenerator, Callable, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated
from urllib.parse import quote

from pydantic import Field, StrictFloat, StrictInt, StrictStr
from typing import List, Optional, Union
from typing_extensions import Annotated
from wandelbots_api_client.models.execute_trajectory_request import ExecuteTrajectoryRequest
from wandelbots_api_client.models.execute_trajectory_response import ExecuteTrajectoryResponse
from wandelbots_api_client.models.get_trajectory_response import GetTrajectoryResponse
from wandelbots_api_client.models.get_trajectory_sample_response import GetTrajectorySampleResponse
from wandelbots_api_client.models.motion_ids_list_response import MotionIdsListResponse
from wandelbots_api_client.models.plan_collision_free_ptp_request import PlanCollisionFreePTPRequest
from wandelbots_api_client.models.plan_request import PlanRequest
from wandelbots_api_client.models.plan_response import PlanResponse
from wandelbots_api_client.models.plan_trajectory_request import PlanTrajectoryRequest
from wandelbots_api_client.models.plan_trajectory_response import PlanTrajectoryResponse
from wandelbots_api_client.models.planned_motion import PlannedMotion
from wandelbots_api_client.models.stream_move_request import StreamMoveRequest
from wandelbots_api_client.models.stream_move_response import StreamMoveResponse

from wandelbots_api_client.api_client import ApiClient, RequestSerialized
from wandelbots_api_client.api_response import ApiResponse
from wandelbots_api_client.rest import RESTResponseType

class MotionApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    async def delete_all_motions(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """All Motions

        Delete all registered motions.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_all_motions_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_all_motions_with_http_info(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """All Motions

        Delete all registered motions.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_all_motions_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_all_motions_without_preload_content(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """All Motions

        Delete all registered motions.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_all_motions_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_all_motions_serialize(
        self,
        cell,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/cells/{cell}/motions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def delete_motion(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Remove

        Remove a previously created motion from cache. Use [listMotions](listMotions) to list all available motions. Motions are removed automatically if the motion group or the corresponding controller is disconnected.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_motion_serialize(
            cell=cell,
            motion=motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_motion_with_http_info(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Remove

        Remove a previously created motion from cache. Use [listMotions](listMotions) to list all available motions. Motions are removed automatically if the motion group or the corresponding controller is disconnected.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_motion_serialize(
            cell=cell,
            motion=motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_motion_without_preload_content(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Remove

        Remove a previously created motion from cache. Use [listMotions](listMotions) to list all available motions. Motions are removed automatically if the motion group or the corresponding controller is disconnected.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_motion_serialize(
            cell=cell,
            motion=motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_motion_serialize(
        self,
        cell,
        motion,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if motion is not None:
            _path_params['motion'] = motion
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/cells/{cell}/motions/{motion}/delete',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def execute_trajectory(self, cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")], client_request_generator: Callable[[AsyncGenerator[ExecuteTrajectoryResponse, None]], AsyncGenerator[ExecuteTrajectoryRequest, None]]) -> None:  # noqa: E501
        """Execute Trajectory  # noqa: E501

        > **Note:** This is a websocket endpoint.  Provides execution control over a previously planned trajectory. Enables the caller to attach I/O actions to the trajectory.  Understanding the concept of location:   The location or path parameter specifies the exact position along a trajectory.   The location is a scalar value that ranges from 0 to `n`,   where `n` denotes the number of motion commands, or trajectory segments, e.g. line, p2p, etc. See [planMotion](planMotion).   Each integer value of the location corresponds to one motion command, e.g. 3.0 to 3.999 could be a line.  ### Preconditions  - The motion group's control mode is not claimed by any other endpoint. - The motion group's joint position are at start location specified with InitializeMovementRequest.  ### Requests  #### 1. Send InitializeMovementRequest to lock the trajectory to this connection   The following actions are executed:   - Sets robot controller mode to control mode,   - Sets start location of the execution    Keep in mind that only a single trajectory can be locked to a websocket connection at a time and not unlocked anymore.   To execute another trajectory, a new connection must be established.  #### 2. Send StartMovementRequest to start the movement  Sets direction of movement, default is forward.  #### **Optional**  - To pause, send PauseMovementRequest before the movement has reached its end location. - Change the movement's velocity with PlaybackSpeedRequest after initializing the movement with InitializeMovementRequest.  ### Responses  - InitializeMovementResponse is sent to signal the success or failure of the InitializeMovementRequest. - Movement responses are streamed after a StartMovementRequest successfully started the movement.   Movement responses are streamed in a rate that is defined as the multiple of the controller step-rate closest to   but not exceeding the rate configured by InitializeMovementRequest. - Standstill reponse  is sent once the movement has finished or has come to a standstill due to a pause. - PauseMovementResponse is sent to signal the success of the PauseMovementRequest. It does not signal the end of the movement.   End of movement is signaled by Standstill reponse . - PlaybackSpeedResponse is sent to signal the success of the PlaybackSpeedRequest. - MovementError with error details is sent in case of an unexpected error, e.g. controller disconnects during movement.  ### Tips and Tricks  - A movement can be paused and resumed by sending PauseMovementRequest and StartMovementRequest. - Send PlaybackSpeedRequest before StartMovementRequest to reduce the velocity of the movement before it starts. - Send PlaybackSpeedRequest repeatedly to implement a slider. The velocity of the motion group can be adjusted with each controller step. Therefore, if your app needs a slider-like UI to alter the velocity of a currently running movement, you can send PlaybackSpeedRequest with different speed values repeatedly during the movement. - A closed trajectory (end and start joint position are equal) can be repeated by sending StartMovementRequest after the movement has finished.   # noqa: E501
        :param client_request_generator: An AsyncGenerator that yields request of type ExecuteTrajectoryRequest and takes an AsyncGenerator of ExecuteTrajectoryResponse as an input argument (required)
        :info All responses from the server will be yielded to client_request_generator through the (AsyncGenerator[ExecuteTrajectoryResponse, None])
        :type AsyncGenerator[ExecuteTrajectoryRequest, None]
        """
        def format_path_parameters(path):
            # Find all substrings that are enclosed in brackets
            bracket_contents = re.findall(r'\{(.*?)\}', path)

            # For each found substring, alter it to match the python variable name
            for content in bracket_contents:
                content = "{" + content + "}"
                modified_content = humps.dekebabize(content)
                path = path.replace(content, modified_content)

            return path

        async def iterate_responses(ws) -> AsyncGenerator[ExecuteTrajectoryResponse, None]:
            async for response in ws:
                if "Cancelled on the server side" in response:
                    break
                response_data = json.loads(response)
                if "result" not in response_data:
                    raise Exception(response_data)
                yield ExecuteTrajectoryResponse.from_dict(response_data["result"])

        path = format_path_parameters("/cells/{cell}/motions/executetrajectory")
        path = path.format(cell=cell,)

        headers = websockets.Headers()
        tmp_host = self.api_client.configuration.host
        if self.api_client.configuration.host.startswith("https://"):
            # Basic Auth
            if self.api_client.configuration.username:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{self.api_client.configuration.username}:{self.api_client.configuration.password}@{tmp_host}"

            # OAuth2
            elif self.api_client.configuration.access_token:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{tmp_host}"
                headers = websockets.Headers([
                    ("Authorization", f"Bearer {self.api_client.configuration.access_token}")
                ])
        else:
            tmp_host = tmp_host.replace("http://", "ws://")

        full_url = furl(tmp_host + path)

        async with websockets.connect(full_url.url, open_timeout=10, additional_headers=headers) as websocket:
            async for request in client_request_generator(iterate_responses(websocket)):
                await websocket.send(request.model_dump_json(by_alias=True))


    @validate_call
    async def get_motion_trajectory(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        sample_time: Annotated[StrictInt, Field(description="The value of `sample_time` is the time in milliseconds (ms) between each point in the trajectory. ")],
        responses_coordinate_system: Annotated[Optional[StrictStr], Field(description="Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default: world coordinate system. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetTrajectoryResponse:
        """Get Trajectory

        Get the trajectory of a planned motion with defined `sample_time` in milliseconds (ms). The trajectory is a list of points containing cartesian and joint data. The cartesian data is in the requested coordinate system. To get a single point of the trajectory, please use the [getMotionTrajectorySample](getMotionTrajectorySample) endpoint. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param sample_time: The value of `sample_time` is the time in milliseconds (ms) between each point in the trajectory.  (required)
        :type sample_time: int
        :param responses_coordinate_system: Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default: world coordinate system. 
        :type responses_coordinate_system: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_trajectory_serialize(
            cell=cell,
            motion=motion,
            sample_time=sample_time,
            responses_coordinate_system=responses_coordinate_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTrajectoryResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_motion_trajectory_with_http_info(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        sample_time: Annotated[StrictInt, Field(description="The value of `sample_time` is the time in milliseconds (ms) between each point in the trajectory. ")],
        responses_coordinate_system: Annotated[Optional[StrictStr], Field(description="Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default: world coordinate system. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetTrajectoryResponse]:
        """Get Trajectory

        Get the trajectory of a planned motion with defined `sample_time` in milliseconds (ms). The trajectory is a list of points containing cartesian and joint data. The cartesian data is in the requested coordinate system. To get a single point of the trajectory, please use the [getMotionTrajectorySample](getMotionTrajectorySample) endpoint. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param sample_time: The value of `sample_time` is the time in milliseconds (ms) between each point in the trajectory.  (required)
        :type sample_time: int
        :param responses_coordinate_system: Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default: world coordinate system. 
        :type responses_coordinate_system: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_trajectory_serialize(
            cell=cell,
            motion=motion,
            sample_time=sample_time,
            responses_coordinate_system=responses_coordinate_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTrajectoryResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_motion_trajectory_without_preload_content(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        sample_time: Annotated[StrictInt, Field(description="The value of `sample_time` is the time in milliseconds (ms) between each point in the trajectory. ")],
        responses_coordinate_system: Annotated[Optional[StrictStr], Field(description="Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default: world coordinate system. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Trajectory

        Get the trajectory of a planned motion with defined `sample_time` in milliseconds (ms). The trajectory is a list of points containing cartesian and joint data. The cartesian data is in the requested coordinate system. To get a single point of the trajectory, please use the [getMotionTrajectorySample](getMotionTrajectorySample) endpoint. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param sample_time: The value of `sample_time` is the time in milliseconds (ms) between each point in the trajectory.  (required)
        :type sample_time: int
        :param responses_coordinate_system: Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default: world coordinate system. 
        :type responses_coordinate_system: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_trajectory_serialize(
            cell=cell,
            motion=motion,
            sample_time=sample_time,
            responses_coordinate_system=responses_coordinate_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTrajectoryResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_motion_trajectory_serialize(
        self,
        cell,
        motion,
        sample_time,
        responses_coordinate_system,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if motion is not None:
            _path_params['motion'] = motion
        # process the query parameters
        if sample_time is not None:
            
            _query_params.append(('sample_time', sample_time))
            
        if responses_coordinate_system is not None:
            
            _query_params.append(('responses_coordinate_system', responses_coordinate_system))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/motions/{motion}/trajectory',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def get_motion_trajectory_sample(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        location_on_trajectory: Optional[Union[StrictFloat, StrictInt]] = None,
        response_coordinate_system: Annotated[Optional[StrictStr], Field(description="Unique identifier addressing a coordinate system in which the cartesian data of the response should be converted to. Default is the world coordinate system.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetTrajectorySampleResponse:
        """Get Trajectory Sample

        -| Get a single point at a certain location of a planned motion. To get the whole trajectory, use the [getMotionTrajectory](getMotionTrajectory) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param location_on_trajectory:
        :type location_on_trajectory: float
        :param response_coordinate_system: Unique identifier addressing a coordinate system in which the cartesian data of the response should be converted to. Default is the world coordinate system.
        :type response_coordinate_system: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_trajectory_sample_serialize(
            cell=cell,
            motion=motion,
            location_on_trajectory=location_on_trajectory,
            response_coordinate_system=response_coordinate_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTrajectorySampleResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_motion_trajectory_sample_with_http_info(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        location_on_trajectory: Optional[Union[StrictFloat, StrictInt]] = None,
        response_coordinate_system: Annotated[Optional[StrictStr], Field(description="Unique identifier addressing a coordinate system in which the cartesian data of the response should be converted to. Default is the world coordinate system.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetTrajectorySampleResponse]:
        """Get Trajectory Sample

        -| Get a single point at a certain location of a planned motion. To get the whole trajectory, use the [getMotionTrajectory](getMotionTrajectory) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param location_on_trajectory:
        :type location_on_trajectory: float
        :param response_coordinate_system: Unique identifier addressing a coordinate system in which the cartesian data of the response should be converted to. Default is the world coordinate system.
        :type response_coordinate_system: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_trajectory_sample_serialize(
            cell=cell,
            motion=motion,
            location_on_trajectory=location_on_trajectory,
            response_coordinate_system=response_coordinate_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTrajectorySampleResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_motion_trajectory_sample_without_preload_content(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        location_on_trajectory: Optional[Union[StrictFloat, StrictInt]] = None,
        response_coordinate_system: Annotated[Optional[StrictStr], Field(description="Unique identifier addressing a coordinate system in which the cartesian data of the response should be converted to. Default is the world coordinate system.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Trajectory Sample

        -| Get a single point at a certain location of a planned motion. To get the whole trajectory, use the [getMotionTrajectory](getMotionTrajectory) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param location_on_trajectory:
        :type location_on_trajectory: float
        :param response_coordinate_system: Unique identifier addressing a coordinate system in which the cartesian data of the response should be converted to. Default is the world coordinate system.
        :type response_coordinate_system: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_trajectory_sample_serialize(
            cell=cell,
            motion=motion,
            location_on_trajectory=location_on_trajectory,
            response_coordinate_system=response_coordinate_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTrajectorySampleResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_motion_trajectory_sample_serialize(
        self,
        cell,
        motion,
        location_on_trajectory,
        response_coordinate_system,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if motion is not None:
            _path_params['motion'] = motion
        # process the query parameters
        if location_on_trajectory is not None:
            
            _query_params.append(('location_on_trajectory', location_on_trajectory))
            
        if response_coordinate_system is not None:
            
            _query_params.append(('response_coordinate_system', response_coordinate_system))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/motions/{motion}/trajectorysample',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def get_planned_motion(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        sample_time: Annotated[Optional[StrictInt], Field(description="-| The value of `sample_time` is the time in milliseconds (ms) between each datapoint of the planned motion. Optional. If not provided, the data is returned as it is stored internally and equidistant sampling is not guaranteed.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PlannedMotion:
        """Get Planned Motion

        Get the joint data of a planned motion. The planned motion contains only the joint information, to persistently store and reload it later. The data will be sampled equidistantly with defined `sample_time` in milliseconds (ms). If not provided, the data is returned as it is stored on Wandelbots Nova system.  To request cartesian data for visualization purposes, use the [getMotionTrajectory](getMotionTrajectory) endpoint. To get a single point of the planned motion, use the [getMotionTrajectorySample](getMotionTrajectorySample) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param sample_time: -| The value of `sample_time` is the time in milliseconds (ms) between each datapoint of the planned motion. Optional. If not provided, the data is returned as it is stored internally and equidistant sampling is not guaranteed.
        :type sample_time: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_planned_motion_serialize(
            cell=cell,
            motion=motion,
            sample_time=sample_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlannedMotion",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_planned_motion_with_http_info(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        sample_time: Annotated[Optional[StrictInt], Field(description="-| The value of `sample_time` is the time in milliseconds (ms) between each datapoint of the planned motion. Optional. If not provided, the data is returned as it is stored internally and equidistant sampling is not guaranteed.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PlannedMotion]:
        """Get Planned Motion

        Get the joint data of a planned motion. The planned motion contains only the joint information, to persistently store and reload it later. The data will be sampled equidistantly with defined `sample_time` in milliseconds (ms). If not provided, the data is returned as it is stored on Wandelbots Nova system.  To request cartesian data for visualization purposes, use the [getMotionTrajectory](getMotionTrajectory) endpoint. To get a single point of the planned motion, use the [getMotionTrajectorySample](getMotionTrajectorySample) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param sample_time: -| The value of `sample_time` is the time in milliseconds (ms) between each datapoint of the planned motion. Optional. If not provided, the data is returned as it is stored internally and equidistant sampling is not guaranteed.
        :type sample_time: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_planned_motion_serialize(
            cell=cell,
            motion=motion,
            sample_time=sample_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlannedMotion",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_planned_motion_without_preload_content(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        sample_time: Annotated[Optional[StrictInt], Field(description="-| The value of `sample_time` is the time in milliseconds (ms) between each datapoint of the planned motion. Optional. If not provided, the data is returned as it is stored internally and equidistant sampling is not guaranteed.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Planned Motion

        Get the joint data of a planned motion. The planned motion contains only the joint information, to persistently store and reload it later. The data will be sampled equidistantly with defined `sample_time` in milliseconds (ms). If not provided, the data is returned as it is stored on Wandelbots Nova system.  To request cartesian data for visualization purposes, use the [getMotionTrajectory](getMotionTrajectory) endpoint. To get a single point of the planned motion, use the [getMotionTrajectorySample](getMotionTrajectorySample) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param sample_time: -| The value of `sample_time` is the time in milliseconds (ms) between each datapoint of the planned motion. Optional. If not provided, the data is returned as it is stored internally and equidistant sampling is not guaranteed.
        :type sample_time: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_planned_motion_serialize(
            cell=cell,
            motion=motion,
            sample_time=sample_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlannedMotion",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_planned_motion_serialize(
        self,
        cell,
        motion,
        sample_time,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if motion is not None:
            _path_params['motion'] = motion
        # process the query parameters
        if sample_time is not None:
            
            _query_params.append(('sample_time', sample_time))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/motions/{motion}/planned-motion',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def get_planning_motion_group_models(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[str]:
        """Motion Group Models for Planning

        Returns motion group models that are supported for planning. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_planning_motion_group_models_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[str]",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_planning_motion_group_models_with_http_info(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[str]]:
        """Motion Group Models for Planning

        Returns motion group models that are supported for planning. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_planning_motion_group_models_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[str]",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_planning_motion_group_models_without_preload_content(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Motion Group Models for Planning

        Returns motion group models that are supported for planning. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_planning_motion_group_models_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[str]",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_planning_motion_group_models_serialize(
        self,
        cell,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/motion-planning/motion-group-models',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def list_motions(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MotionIdsListResponse:
        """List All Motions

        List all currently planned and available motions. Use [planMotion](planMotion) to plan a new motion. Motions are removed if the corresponding motion group or controller disconnects.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_motions_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MotionIdsListResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_motions_with_http_info(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MotionIdsListResponse]:
        """List All Motions

        List all currently planned and available motions. Use [planMotion](planMotion) to plan a new motion. Motions are removed if the corresponding motion group or controller disconnects.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_motions_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MotionIdsListResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_motions_without_preload_content(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List All Motions

        List all currently planned and available motions. Use [planMotion](planMotion) to plan a new motion. Motions are removed if the corresponding motion group or controller disconnects.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_motions_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MotionIdsListResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_motions_serialize(
        self,
        cell,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/motions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def load_planned_motion(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        planned_motion: PlannedMotion,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PlanResponse:
        """Load Planned Motion

        Loads and validates the data of a planned motion into a motion session. The response contains information about the validated motion.  Validation can lead to three different results: - Fully valid: The whole planned motion can be executed from start to end. The response will contain the session to move the robot. - Partially valid: Only parts of the planned motion can be executed. The response will contain the session to move the robot and information about the failure for the part that is not executable. - Invalid: The planned motion can not be executed. The response will tell you, which information about the reason of failure.  If the motion is at least partially valid, the parts of the motion that are valid can be executed using the [streamMoveForward](streamMoveForward) endpoint.  You can use the following workflows:   - Plan motions using the [planMotion](planMotion) endpoint,   - Store the planned motion persistently,   - Use this endpoint to reload the stored motion and get a motion session for it.   - Execute the loaded motion using the [streamMoveForward](streamMoveForward) endpoint.  OR:   - Generate a planned motion with [planTrajectory](planTrajectory) or your own motion planner,   - Send the planned motion to this endpoint to validate it and get a motion session for it,   - Execute your motion using the [streamMoveForward](streamMoveForward) endpoint.  Once a planned motion is validated, it is treated like a motion session and will appear in the list of available motions, see [listMotions](listMotions) endpoint. You can then execute a motion session with the [streamMoveForward](streamMoveForward) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param planned_motion: (required)
        :type planned_motion: PlannedMotion
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._load_planned_motion_serialize(
            cell=cell,
            planned_motion=planned_motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def load_planned_motion_with_http_info(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        planned_motion: PlannedMotion,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PlanResponse]:
        """Load Planned Motion

        Loads and validates the data of a planned motion into a motion session. The response contains information about the validated motion.  Validation can lead to three different results: - Fully valid: The whole planned motion can be executed from start to end. The response will contain the session to move the robot. - Partially valid: Only parts of the planned motion can be executed. The response will contain the session to move the robot and information about the failure for the part that is not executable. - Invalid: The planned motion can not be executed. The response will tell you, which information about the reason of failure.  If the motion is at least partially valid, the parts of the motion that are valid can be executed using the [streamMoveForward](streamMoveForward) endpoint.  You can use the following workflows:   - Plan motions using the [planMotion](planMotion) endpoint,   - Store the planned motion persistently,   - Use this endpoint to reload the stored motion and get a motion session for it.   - Execute the loaded motion using the [streamMoveForward](streamMoveForward) endpoint.  OR:   - Generate a planned motion with [planTrajectory](planTrajectory) or your own motion planner,   - Send the planned motion to this endpoint to validate it and get a motion session for it,   - Execute your motion using the [streamMoveForward](streamMoveForward) endpoint.  Once a planned motion is validated, it is treated like a motion session and will appear in the list of available motions, see [listMotions](listMotions) endpoint. You can then execute a motion session with the [streamMoveForward](streamMoveForward) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param planned_motion: (required)
        :type planned_motion: PlannedMotion
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._load_planned_motion_serialize(
            cell=cell,
            planned_motion=planned_motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def load_planned_motion_without_preload_content(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        planned_motion: PlannedMotion,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Load Planned Motion

        Loads and validates the data of a planned motion into a motion session. The response contains information about the validated motion.  Validation can lead to three different results: - Fully valid: The whole planned motion can be executed from start to end. The response will contain the session to move the robot. - Partially valid: Only parts of the planned motion can be executed. The response will contain the session to move the robot and information about the failure for the part that is not executable. - Invalid: The planned motion can not be executed. The response will tell you, which information about the reason of failure.  If the motion is at least partially valid, the parts of the motion that are valid can be executed using the [streamMoveForward](streamMoveForward) endpoint.  You can use the following workflows:   - Plan motions using the [planMotion](planMotion) endpoint,   - Store the planned motion persistently,   - Use this endpoint to reload the stored motion and get a motion session for it.   - Execute the loaded motion using the [streamMoveForward](streamMoveForward) endpoint.  OR:   - Generate a planned motion with [planTrajectory](planTrajectory) or your own motion planner,   - Send the planned motion to this endpoint to validate it and get a motion session for it,   - Execute your motion using the [streamMoveForward](streamMoveForward) endpoint.  Once a planned motion is validated, it is treated like a motion session and will appear in the list of available motions, see [listMotions](listMotions) endpoint. You can then execute a motion session with the [streamMoveForward](streamMoveForward) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param planned_motion: (required)
        :type planned_motion: PlannedMotion
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._load_planned_motion_serialize(
            cell=cell,
            planned_motion=planned_motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _load_planned_motion_serialize(
        self,
        cell,
        planned_motion,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if planned_motion is not None:
            _body_params = planned_motion


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/cells/{cell}/planned-motions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def plan_collision_free_ptp(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        plan_collision_free_ptp_request: Optional[PlanCollisionFreePTPRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PlanTrajectoryResponse:
        """Plan Collision Free PTP

        Plans a collision-free PTP motion for a single motion group.  > **Note:** This endpoint is experimental and might experience functional changes in the future.  Use the following workflow to execute a planned trajectory: 1. Plan collision-free movement/motion. 2. Validate and load the planned trajectory using the [loadPlannedMotion](loadPlannedMotion) endpoint. 3. Execute the loaded trajectory using the [streamMove](streamMove) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param plan_collision_free_ptp_request:
        :type plan_collision_free_ptp_request: PlanCollisionFreePTPRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._plan_collision_free_ptp_serialize(
            cell=cell,
            plan_collision_free_ptp_request=plan_collision_free_ptp_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanTrajectoryResponse",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def plan_collision_free_ptp_with_http_info(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        plan_collision_free_ptp_request: Optional[PlanCollisionFreePTPRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PlanTrajectoryResponse]:
        """Plan Collision Free PTP

        Plans a collision-free PTP motion for a single motion group.  > **Note:** This endpoint is experimental and might experience functional changes in the future.  Use the following workflow to execute a planned trajectory: 1. Plan collision-free movement/motion. 2. Validate and load the planned trajectory using the [loadPlannedMotion](loadPlannedMotion) endpoint. 3. Execute the loaded trajectory using the [streamMove](streamMove) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param plan_collision_free_ptp_request:
        :type plan_collision_free_ptp_request: PlanCollisionFreePTPRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._plan_collision_free_ptp_serialize(
            cell=cell,
            plan_collision_free_ptp_request=plan_collision_free_ptp_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanTrajectoryResponse",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def plan_collision_free_ptp_without_preload_content(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        plan_collision_free_ptp_request: Optional[PlanCollisionFreePTPRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Plan Collision Free PTP

        Plans a collision-free PTP motion for a single motion group.  > **Note:** This endpoint is experimental and might experience functional changes in the future.  Use the following workflow to execute a planned trajectory: 1. Plan collision-free movement/motion. 2. Validate and load the planned trajectory using the [loadPlannedMotion](loadPlannedMotion) endpoint. 3. Execute the loaded trajectory using the [streamMove](streamMove) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param plan_collision_free_ptp_request:
        :type plan_collision_free_ptp_request: PlanCollisionFreePTPRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._plan_collision_free_ptp_serialize(
            cell=cell,
            plan_collision_free_ptp_request=plan_collision_free_ptp_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanTrajectoryResponse",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _plan_collision_free_ptp_serialize(
        self,
        cell,
        plan_collision_free_ptp_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if plan_collision_free_ptp_request is not None:
            _body_params = plan_collision_free_ptp_request


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/cells/{cell}/motion-planning/plan-collision-free-ptp',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def plan_motion(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        plan_request: PlanRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PlanResponse:
        """(Deprecated) Plan Motion

        **Deprecated**. Use [planTrajectory](planTrajectory) and [loadPlannedMotion](loadPlannedMotion).  Plans a new motion for a single previously configured [motion group](listMotionGroups). Motions are described by a sequence of motion commands starting with start joints. A motion is planned from standstill to standstill. A single motion has constant TCP and payload. Currently, I/O actions can't be attached to a motion to execute the action in realtime while a motion is executed. If an I/O is needed at a specific point, multiple motions need to be planned. If an I/O is needed to be set while a motion is executed, the enpoint [setOutputValues](setOutputValues) could be used.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param plan_request: (required)
        :type plan_request: PlanRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /cells/{cell}/motions is deprecated.", DeprecationWarning)

        _param = self._plan_motion_serialize(
            cell=cell,
            plan_request=plan_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def plan_motion_with_http_info(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        plan_request: PlanRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PlanResponse]:
        """(Deprecated) Plan Motion

        **Deprecated**. Use [planTrajectory](planTrajectory) and [loadPlannedMotion](loadPlannedMotion).  Plans a new motion for a single previously configured [motion group](listMotionGroups). Motions are described by a sequence of motion commands starting with start joints. A motion is planned from standstill to standstill. A single motion has constant TCP and payload. Currently, I/O actions can't be attached to a motion to execute the action in realtime while a motion is executed. If an I/O is needed at a specific point, multiple motions need to be planned. If an I/O is needed to be set while a motion is executed, the enpoint [setOutputValues](setOutputValues) could be used.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param plan_request: (required)
        :type plan_request: PlanRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /cells/{cell}/motions is deprecated.", DeprecationWarning)

        _param = self._plan_motion_serialize(
            cell=cell,
            plan_request=plan_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def plan_motion_without_preload_content(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        plan_request: PlanRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Plan Motion

        **Deprecated**. Use [planTrajectory](planTrajectory) and [loadPlannedMotion](loadPlannedMotion).  Plans a new motion for a single previously configured [motion group](listMotionGroups). Motions are described by a sequence of motion commands starting with start joints. A motion is planned from standstill to standstill. A single motion has constant TCP and payload. Currently, I/O actions can't be attached to a motion to execute the action in realtime while a motion is executed. If an I/O is needed at a specific point, multiple motions need to be planned. If an I/O is needed to be set while a motion is executed, the enpoint [setOutputValues](setOutputValues) could be used.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param plan_request: (required)
        :type plan_request: PlanRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /cells/{cell}/motions is deprecated.", DeprecationWarning)

        _param = self._plan_motion_serialize(
            cell=cell,
            plan_request=plan_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _plan_motion_serialize(
        self,
        cell,
        plan_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if plan_request is not None:
            _body_params = plan_request


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/cells/{cell}/motions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def plan_trajectory(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        plan_trajectory_request: Optional[PlanTrajectoryRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PlanTrajectoryResponse:
        """Plan Trajectory

        Plans a new trajectory for a single motion group.  Describe the trajectory as a sequence of motion commands that the robots TCP should follow.  Use the following workflow to execute a planned trajectory: 1. Plan a trajectory. 2. Validate and load the planned trajectory using the [loadPlannedMotion](loadPlannedMotion) endpoint. 3. Execute the loaded trajectory using the [streamMove](streamMove) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param plan_trajectory_request:
        :type plan_trajectory_request: PlanTrajectoryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._plan_trajectory_serialize(
            cell=cell,
            plan_trajectory_request=plan_trajectory_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanTrajectoryResponse",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def plan_trajectory_with_http_info(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        plan_trajectory_request: Optional[PlanTrajectoryRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PlanTrajectoryResponse]:
        """Plan Trajectory

        Plans a new trajectory for a single motion group.  Describe the trajectory as a sequence of motion commands that the robots TCP should follow.  Use the following workflow to execute a planned trajectory: 1. Plan a trajectory. 2. Validate and load the planned trajectory using the [loadPlannedMotion](loadPlannedMotion) endpoint. 3. Execute the loaded trajectory using the [streamMove](streamMove) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param plan_trajectory_request:
        :type plan_trajectory_request: PlanTrajectoryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._plan_trajectory_serialize(
            cell=cell,
            plan_trajectory_request=plan_trajectory_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanTrajectoryResponse",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def plan_trajectory_without_preload_content(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        plan_trajectory_request: Optional[PlanTrajectoryRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Plan Trajectory

        Plans a new trajectory for a single motion group.  Describe the trajectory as a sequence of motion commands that the robots TCP should follow.  Use the following workflow to execute a planned trajectory: 1. Plan a trajectory. 2. Validate and load the planned trajectory using the [loadPlannedMotion](loadPlannedMotion) endpoint. 3. Execute the loaded trajectory using the [streamMove](streamMove) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param plan_trajectory_request:
        :type plan_trajectory_request: PlanTrajectoryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._plan_trajectory_serialize(
            cell=cell,
            plan_trajectory_request=plan_trajectory_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanTrajectoryResponse",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _plan_trajectory_serialize(
        self,
        cell,
        plan_trajectory_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if plan_trajectory_request is not None:
            _body_params = plan_trajectory_request


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/cells/{cell}/motion-planning/plan-trajectory',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def stop_execution(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Stop

        Stops an active motion gracefully with deceleration until standstill while staying on the planned trajectory. When an active movement is stopped any further update request will be rejected. The active movement request returns until the robot has reached standstill. Currently it is not possible to restart the motion. Please send in a feature request if you need to restart/continue the motion.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._stop_execution_serialize(
            cell=cell,
            motion=motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def stop_execution_with_http_info(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Stop

        Stops an active motion gracefully with deceleration until standstill while staying on the planned trajectory. When an active movement is stopped any further update request will be rejected. The active movement request returns until the robot has reached standstill. Currently it is not possible to restart the motion. Please send in a feature request if you need to restart/continue the motion.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._stop_execution_serialize(
            cell=cell,
            motion=motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def stop_execution_without_preload_content(
        self,
        cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Stop

        Stops an active motion gracefully with deceleration until standstill while staying on the planned trajectory. When an active movement is stopped any further update request will be rejected. The active movement request returns until the robot has reached standstill. Currently it is not possible to restart the motion. Please send in a feature request if you need to restart/continue the motion.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._stop_execution_serialize(
            cell=cell,
            motion=motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _stop_execution_serialize(
        self,
        cell,
        motion,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if motion is not None:
            _path_params['motion'] = motion
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/cells/{cell}/motions/{motion}/stop',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def stream_move(self, cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")], client_request_generator: Callable[[AsyncGenerator[StreamMoveResponse, None]], AsyncGenerator[StreamMoveRequest, None]]) -> None:  # noqa: E501
        """(Deprecated) Stream Move  # noqa: E501

        # EXPERIMENTAL  > **Note:** This endpoint is experimental and is replaced by the `executeTrajectory` endpoint in the next release.  Moves the motion group forward or backward along a previously planned motion. Or request to move the motion group via joint point-to-point to a given location on a planned motion. Or set the playback speed of the motion. Or stop the motion execution.   # noqa: E501
        :param client_request_generator: An AsyncGenerator that yields request of type StreamMoveRequest and takes an AsyncGenerator of StreamMoveResponse as an input argument (required)
        :info All responses from the server will be yielded to client_request_generator through the (AsyncGenerator[StreamMoveResponse, None])
        :type AsyncGenerator[StreamMoveRequest, None]
        """
        def format_path_parameters(path):
            # Find all substrings that are enclosed in brackets
            bracket_contents = re.findall(r'\{(.*?)\}', path)

            # For each found substring, alter it to match the python variable name
            for content in bracket_contents:
                content = "{" + content + "}"
                modified_content = humps.dekebabize(content)
                path = path.replace(content, modified_content)

            return path

        async def iterate_responses(ws) -> AsyncGenerator[StreamMoveResponse, None]:
            async for response in ws:
                if "Cancelled on the server side" in response:
                    break
                response_data = json.loads(response)
                if "result" not in response_data:
                    raise Exception(response_data)
                yield StreamMoveResponse.from_dict(response_data["result"])

        path = format_path_parameters("/cells/{cell}/motions/streammove")
        path = path.format(cell=cell,)

        headers = websockets.Headers()
        tmp_host = self.api_client.configuration.host
        if self.api_client.configuration.host.startswith("https://"):
            # Basic Auth
            if self.api_client.configuration.username:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{self.api_client.configuration.username}:{self.api_client.configuration.password}@{tmp_host}"

            # OAuth2
            elif self.api_client.configuration.access_token:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{tmp_host}"
                headers = websockets.Headers([
                    ("Authorization", f"Bearer {self.api_client.configuration.access_token}")
                ])
        else:
            tmp_host = tmp_host.replace("http://", "ws://")

        full_url = furl(tmp_host + path)

        async with websockets.connect(full_url.url, open_timeout=10, additional_headers=headers) as websocket:
            async for request in client_request_generator(iterate_responses(websocket)):
                await websocket.send(request.model_dump_json(by_alias=True))


    @validate_call
    async def stream_move_backward(self, cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")], motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")], playback_speed_in_percent: Annotated[StrictInt, Field(description="Set the velocity for executed movements of the motion in percent. A percentage of 100% means that the robot moves as fast as possible without violating the limits. Setting this value does not affect the overall shape of the velocity profile. Everything is slowed down by the same factor. Therefore, this should only be used for teaching and trajectory evaluation purposes. If the process requires a certain velocity, the respective limits should be set when planning the motion. This will not change the velocity override of the controller. The controller velocity override value shall be 100% to ensure controllability of the motion group. ")], response_rate: Annotated[Optional[StrictInt], Field(description="Update rate for the response message in milliseconds (ms). Default is 200 ms. We recommend to use the step rate of the controller or a multiple of the step rate as Nova updates the state in the controller's step rate as well. Minimal response rate is the step rate of controller.")] = None, response_coordinate_system: Annotated[Optional[StrictStr], Field(description="Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default is the world coordinate system. ")] = None, start_location_on_trajectory: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Location the motion is requested to start at. The default value is the end of the trajectory. The location is a scalar value that defines a position along a path, typically ranging from 0 to `n`, where `n` denotes the number of motion commands. Each integer value of the location corresponds to a specific motion command, while non-integer values interpolate positions within the segments. The location is calculated from the joint path. ")] = None) -> AsyncGenerator[StreamMoveResponse, None]:  # noqa: E501
        """(Deprecated) Stream Backward  # noqa: E501

        > **Note:** This endpoint is deprecated. Use the [executeTrajectory](executeTrajectory) endpoint instead. Request to move the motion group backward along a previously planned motion. Once started, you can stop a motion using the [stopExecution](stopExecution) endpoint. Prerequisites, before starting the motion execution:  - The motion group is currently at the endpoint of the planned motion. OR  - The motion was stopped using [stopExecution](stopExecution) endpoint. Then it is possible to resume the motion exection from where it stopped. OR  - The motion group was moved onto the motion using the [streamMoveToTrajectoryViaJointP2P](streamMoveToTrajectoryViaJointP2P) endpoint.  # noqa: E501
        :param request: A StreamMoveBackwardRequest
        :info All responses from the server will be yielded
        :type StreamMoveBackwardRequest
        """
        def format_path_parameters(path):
            # Find all substrings that are enclosed in brackets
            bracket_contents = re.findall(r'\{(.*?)\}', path)

            # For each found substring, replace underscores with spaces
            for content in bracket_contents:
                content = "{" + content + "}"
                modified_content = humps.dekebabize(content)
                path = path.replace(content, modified_content)

            return path

        def append_parameter_connector(url_schema):
            if not "?" in url_schema:
                url_schema += "?"
            else:
                url_schema += "&"
            return url_schema

        path = format_path_parameters("/cells/{cell}/motions/{motion}/executebackward")
        path = path.format(cell=cell,motion=motion,)

        headers = websockets.Headers()
        tmp_host = self.api_client.configuration.host
        if self.api_client.configuration.host.startswith("https://"):
            # Basic Auth
            if self.api_client.configuration.username:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{self.api_client.configuration.username}:{self.api_client.configuration.password}@{tmp_host}"

            # OAuth2
            elif self.api_client.configuration.access_token:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{tmp_host}"
                headers = websockets.Headers([
                    ("Authorization", f"Bearer {self.api_client.configuration.access_token}")
                ])
        else:
            tmp_host = tmp_host.replace("http://", "ws://")

        url_schema = tmp_host + path
        if locals().get("playback_speed_in_percent") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(playback_speed_in_percent, list):
              url_schema += "&".join(["playback_speed_in_percent=" + s for s in playback_speed_in_percent])
            else:
              url_schema += "playback_speed_in_percent="+str(playback_speed_in_percent)
        if locals().get("response_rate") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(response_rate, list):
              url_schema += "&".join(["response_rate=" + s for s in response_rate])
            else:
              url_schema += "response_rate="+str(response_rate)
        if locals().get("response_coordinate_system") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(response_coordinate_system, list):
              url_schema += "&".join(["response_coordinate_system=" + s for s in response_coordinate_system])
            else:
              url_schema += "response_coordinate_system="+str(response_coordinate_system)
        if locals().get("start_location_on_trajectory") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(start_location_on_trajectory, list):
              url_schema += "&".join(["start_location_on_trajectory=" + s for s in start_location_on_trajectory])
            else:
              url_schema += "start_location_on_trajectory="+str(start_location_on_trajectory)
        full_url = furl(url_schema)

        async with websockets.connect(full_url.url, open_timeout=10, additional_headers=headers) as websocket:
            try:
                async for response in websocket:
                    response_data = json.loads(response)
                    if "result" not in response_data:
                        raise Exception(response_data)
                    yield StreamMoveResponse.from_dict(response_data["result"])
            except websockets.exceptions.ConnectionClosed:
                return


    @validate_call
    async def stream_move_forward(self, cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")], motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")], playback_speed_in_percent: Annotated[StrictInt, Field(description="Set the velocity for executed movements of the motion in percent. A percentage of 100% means that the robot moves as fast as possible without violating the limits. Setting this value does not affect the overall shape of the velocity profile. Everything is slowed down by the same factor. Therefore, this should only be used for teaching and trajectory evaluation purposes. If the process requires a certain velocity, the respective limits should be set when planning the motion. This will not change the velocity override of the controller. The controller velocity override value shall be 100% to ensure controllability of the motion group. ")], response_rate: Annotated[Optional[StrictInt], Field(description="Update rate for the response message in milliseconds (ms). Default is 200 ms. We recommend to use the step rate of the controller or a multiple of the step rate as Nova updates the state in the controller's step rate as well. Minimal response rate is the step rate of controller.")] = None, response_coordinate_system: Annotated[Optional[StrictStr], Field(description="Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default is the world coordinate system. ")] = None, start_location_on_trajectory: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Location the motion is requested to start at. The default value is the begin of the trajectory. The location is a scalar value that defines a position along a path, typically ranging from 0 to `n`, where `n` denotes the number of motion commands. Each integer value of the location corresponds to a specific motion command, while non-integer values interpolate positions within the segments. The location is calculated from the joint path. ")] = None) -> AsyncGenerator[StreamMoveResponse, None]:  # noqa: E501
        """(Deprecated) Stream Forward  # noqa: E501

        > **Note:** This endpoint is deprecated. Use the [executeTrajectory](executeTrajectory) endpoint instead. Moves the motion group forward along a previously planned motion. Once started, you can stop a motion using the [stopExecution](stopExecution) endpoint. Prerequisites, before starting the motion execution:  - The motion group is currently at the startpoint of the planned motion. OR  - The motion was stopped using [stopExecution](stopExecution) endpoint. Then it is possible to resume the motion exection from where it stopped. OR  - The motion group was moved onto the motion using the [streamMoveToTrajectoryViaJointP2P](streamMoveToTrajectoryViaJointP2P) endpoint.  # noqa: E501
        :param request: A StreamMoveForwardRequest
        :info All responses from the server will be yielded
        :type StreamMoveForwardRequest
        """
        def format_path_parameters(path):
            # Find all substrings that are enclosed in brackets
            bracket_contents = re.findall(r'\{(.*?)\}', path)

            # For each found substring, replace underscores with spaces
            for content in bracket_contents:
                content = "{" + content + "}"
                modified_content = humps.dekebabize(content)
                path = path.replace(content, modified_content)

            return path

        def append_parameter_connector(url_schema):
            if not "?" in url_schema:
                url_schema += "?"
            else:
                url_schema += "&"
            return url_schema

        path = format_path_parameters("/cells/{cell}/motions/{motion}/executeforward")
        path = path.format(cell=cell,motion=motion,)

        headers = websockets.Headers()
        tmp_host = self.api_client.configuration.host
        if self.api_client.configuration.host.startswith("https://"):
            # Basic Auth
            if self.api_client.configuration.username:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{self.api_client.configuration.username}:{self.api_client.configuration.password}@{tmp_host}"

            # OAuth2
            elif self.api_client.configuration.access_token:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{tmp_host}"
                headers = websockets.Headers([
                    ("Authorization", f"Bearer {self.api_client.configuration.access_token}")
                ])
        else:
            tmp_host = tmp_host.replace("http://", "ws://")

        url_schema = tmp_host + path
        if locals().get("playback_speed_in_percent") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(playback_speed_in_percent, list):
              url_schema += "&".join(["playback_speed_in_percent=" + s for s in playback_speed_in_percent])
            else:
              url_schema += "playback_speed_in_percent="+str(playback_speed_in_percent)
        if locals().get("response_rate") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(response_rate, list):
              url_schema += "&".join(["response_rate=" + s for s in response_rate])
            else:
              url_schema += "response_rate="+str(response_rate)
        if locals().get("response_coordinate_system") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(response_coordinate_system, list):
              url_schema += "&".join(["response_coordinate_system=" + s for s in response_coordinate_system])
            else:
              url_schema += "response_coordinate_system="+str(response_coordinate_system)
        if locals().get("start_location_on_trajectory") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(start_location_on_trajectory, list):
              url_schema += "&".join(["start_location_on_trajectory=" + s for s in start_location_on_trajectory])
            else:
              url_schema += "start_location_on_trajectory="+str(start_location_on_trajectory)
        full_url = furl(url_schema)

        async with websockets.connect(full_url.url, open_timeout=10, additional_headers=headers) as websocket:
            try:
                async for response in websocket:
                    response_data = json.loads(response)
                    if "result" not in response_data:
                        raise Exception(response_data)
                    yield StreamMoveResponse.from_dict(response_data["result"])
            except websockets.exceptions.ConnectionClosed:
                return


    @validate_call
    async def stream_move_to_trajectory_via_joint_ptp(self, cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")], motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")], location_on_trajectory: Union[StrictFloat, StrictInt], limit_override_joint_velocity_limits_joints: Annotated[Optional[List[Union[StrictFloat, StrictInt]]], Field(description="The joint velocity limits for the p2p motion to a previously planned motion.")] = None, limit_override_joint_acceleration_limits_joints: Annotated[Optional[List[Union[StrictFloat, StrictInt]]], Field(description="The joint acceleration limits for the p2p motion to a previously planned motion.")] = None, limit_override_tcp_velocity_limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Maximum allowed TCP velocity in [mm/s].")] = None, limit_override_tcp_acceleration_limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Maximum allowed TCP acceleration in [mm/s^2].")] = None, limit_override_tcp_orientation_velocity_limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Maximum allowed TCP rotation velocity in [rad/s].")] = None, limit_override_tcp_orientation_acceleration_limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Maximum allowed TCP rotation acceleration in [rad/s^2].")] = None, responses_coordinate_system: Optional[StrictStr] = None) -> AsyncGenerator[StreamMoveResponse, None]:  # noqa: E501
        """Stream to Trajectory  # noqa: E501

        Request to move the motion group via joint point-to-point to a given location on a planned motion. You must use this endpoint in order to start moving from an arbritrary location of the trajectory. Afterwards, you are able to call [streamMoveForward](streamMoveForward) or [streamMoveBackward](streamMoveBackward) to move along planned motion. Use the [stopExecution](stopExecution) endpoint to stop the motion gracefully.  # noqa: E501
        :param request: A StreamMoveToTrajectoryViaJointPtpRequest
        :info All responses from the server will be yielded
        :type StreamMoveToTrajectoryViaJointPtpRequest
        """
        def format_path_parameters(path):
            # Find all substrings that are enclosed in brackets
            bracket_contents = re.findall(r'\{(.*?)\}', path)

            # For each found substring, replace underscores with spaces
            for content in bracket_contents:
                content = "{" + content + "}"
                modified_content = humps.dekebabize(content)
                path = path.replace(content, modified_content)

            return path

        def append_parameter_connector(url_schema):
            if not "?" in url_schema:
                url_schema += "?"
            else:
                url_schema += "&"
            return url_schema

        path = format_path_parameters("/cells/{cell}/motions/{motion}/executetotrajectory")
        path = path.format(cell=cell,motion=motion,)

        headers = websockets.Headers()
        tmp_host = self.api_client.configuration.host
        if self.api_client.configuration.host.startswith("https://"):
            # Basic Auth
            if self.api_client.configuration.username:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{self.api_client.configuration.username}:{self.api_client.configuration.password}@{tmp_host}"

            # OAuth2
            elif self.api_client.configuration.access_token:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{tmp_host}"
                headers = websockets.Headers([
                    ("Authorization", f"Bearer {self.api_client.configuration.access_token}")
                ])
        else:
            tmp_host = tmp_host.replace("http://", "ws://")

        url_schema = tmp_host + path
        if locals().get("location_on_trajectory") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(location_on_trajectory, list):
              url_schema += "&".join(["location_on_trajectory=" + s for s in location_on_trajectory])
            else:
              url_schema += "location_on_trajectory="+str(location_on_trajectory)
        if locals().get("limit_override_joint_velocity_limits_joints") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(limit_override_joint_velocity_limits_joints, list):
              url_schema += "&".join(["limit_override.joint_velocity_limits.joints=" + s for s in limit_override_joint_velocity_limits_joints])
            else:
              url_schema += "limit_override.joint_velocity_limits.joints="+str(limit_override_joint_velocity_limits_joints)
        if locals().get("limit_override_joint_acceleration_limits_joints") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(limit_override_joint_acceleration_limits_joints, list):
              url_schema += "&".join(["limit_override.joint_acceleration_limits.joints=" + s for s in limit_override_joint_acceleration_limits_joints])
            else:
              url_schema += "limit_override.joint_acceleration_limits.joints="+str(limit_override_joint_acceleration_limits_joints)
        if locals().get("limit_override_tcp_velocity_limit") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(limit_override_tcp_velocity_limit, list):
              url_schema += "&".join(["limit_override.tcp_velocity_limit=" + s for s in limit_override_tcp_velocity_limit])
            else:
              url_schema += "limit_override.tcp_velocity_limit="+str(limit_override_tcp_velocity_limit)
        if locals().get("limit_override_tcp_acceleration_limit") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(limit_override_tcp_acceleration_limit, list):
              url_schema += "&".join(["limit_override.tcp_acceleration_limit=" + s for s in limit_override_tcp_acceleration_limit])
            else:
              url_schema += "limit_override.tcp_acceleration_limit="+str(limit_override_tcp_acceleration_limit)
        if locals().get("limit_override_tcp_orientation_velocity_limit") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(limit_override_tcp_orientation_velocity_limit, list):
              url_schema += "&".join(["limit_override.tcp_orientation_velocity_limit=" + s for s in limit_override_tcp_orientation_velocity_limit])
            else:
              url_schema += "limit_override.tcp_orientation_velocity_limit="+str(limit_override_tcp_orientation_velocity_limit)
        if locals().get("limit_override_tcp_orientation_acceleration_limit") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(limit_override_tcp_orientation_acceleration_limit, list):
              url_schema += "&".join(["limit_override.tcp_orientation_acceleration_limit=" + s for s in limit_override_tcp_orientation_acceleration_limit])
            else:
              url_schema += "limit_override.tcp_orientation_acceleration_limit="+str(limit_override_tcp_orientation_acceleration_limit)
        if locals().get("responses_coordinate_system") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(responses_coordinate_system, list):
              url_schema += "&".join(["responses_coordinate_system=" + s for s in responses_coordinate_system])
            else:
              url_schema += "responses_coordinate_system="+str(responses_coordinate_system)
        full_url = furl(url_schema)

        async with websockets.connect(full_url.url, open_timeout=10, additional_headers=headers) as websocket:
            try:
                async for response in websocket:
                    response_data = json.loads(response)
                    if "result" not in response_data:
                        raise Exception(response_data)
                    yield StreamMoveResponse.from_dict(response_data["result"])
            except websockets.exceptions.ConnectionClosed:
                return

