# coding: utf-8

"""
    Wandelbots Nova API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from wandelbots_api_client.models.pause_on_io import PauseOnIO
from wandelbots_api_client.models.set_io import SetIO
from wandelbots_api_client.models.start_on_io import StartOnIO
from typing import Optional, Set
from typing_extensions import Self

class MoveRequest(BaseModel):
    """
    Moves the motion group forward or backward along a previously planned motion.  Once started, you can stop a motion using the [stop](StreamStop) endpoint.  Prerequisites, before starting the motion executiont he motion group is currently at the start_location_on_trajectory of the planned motion. 
    """ # noqa: E501
    motion: StrictStr = Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")
    playback_speed_in_percent: StrictInt = Field(description="Set the velocity for executed movements of the motion in percent. A percentage of 100% means that the robot moves as fast as possible without violating the limits. Setting this value does not affect the overall shape of the velocity profile. Everything is slowed down by the same factor. Therefore, this should only be used for teaching and trajectory evaluation purposes. If the process requires a certain velocity, the respective limits should be set when planning the motion. This will not change the velocity override of the controller. The controller velocity override value shall be 100% to ensure controllability of the motion group. ")
    response_rate: Optional[StrictInt] = Field(default=None, description="Update rate for the response message in milliseconds (ms). Default is 200 ms. We recommend to use the step rate of the controller or a multiple of the step rate as Nova updates the state in the controller's step rate as well. Minimal response rate is the step rate of controller. ")
    response_coordinate_system: Optional[StrictStr] = Field(default=None, description="Unique identifier addressing a coordinate system in which the responses should be converted. If not set, world coordinate system is used. ")
    start_location_on_trajectory: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Location the motion is requested to start at. The default value is the begin of the trajectory. The location is a scalar value that defines a position along a path, typically ranging from 0 to `n`, where `n` denotes the number of motion commands. Each integer value of the location corresponds to a specific motion command, while non-integer values interpolate positions within the segments. The location is calculated from the joint path. ")
    set_ios: Optional[List[SetIO]] = Field(default=None, description="Define an arb I/O that is listened to during the motion. If the defined comparator evaluates to true the execution is started. ")
    start_on_io: Optional[StartOnIO] = Field(default=None, description="Defines an I/O that is listened to during the motion. If the defined comparator evaluates to true the execution is started. ")
    pause_on_io: Optional[PauseOnIO] = Field(default=None, description="Defines an I/O that is listened to during the motion. If the defined comparator evaluates to true the execution is paused. ")
    __properties: ClassVar[List[str]] = ["motion", "playback_speed_in_percent", "response_rate", "response_coordinate_system", "start_location_on_trajectory", "set_ios", "start_on_io", "pause_on_io"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MoveRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in set_ios (list)
        _items = []
        if self.set_ios:
            for _item in self.set_ios:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['set_ios'] = _items
        # override the default output from pydantic by calling `to_dict()` of start_on_io
        if self.start_on_io:
            _dict['start_on_io'] = self.start_on_io.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pause_on_io
        if self.pause_on_io:
            _dict['pause_on_io'] = self.pause_on_io.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MoveRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "motion": obj.get("motion"),
            "playback_speed_in_percent": obj.get("playback_speed_in_percent"),
            "response_rate": obj.get("response_rate"),
            "response_coordinate_system": obj.get("response_coordinate_system"),
            "start_location_on_trajectory": obj.get("start_location_on_trajectory"),
            "set_ios": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                SetIO.from_dict(_item) if hasattr(SetIO, 'from_dict') else _item
                # <<< End modification
                for _item in obj["set_ios"]
            ] if obj.get("set_ios") is not None else None,
            "start_on_io": StartOnIO.from_dict(obj["start_on_io"]) if obj.get("start_on_io") is not None else None,
            "pause_on_io": PauseOnIO.from_dict(obj["pause_on_io"]) if obj.get("pause_on_io") is not None else None
        })
        return _obj


