# coding: utf-8

"""
    Wandelbots Nova API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from furl import furl
import json
import humps
import re
import warnings
import websockets
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, AsyncGenerator, Callable, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated
from urllib.parse import quote

from pydantic import Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import List, Optional, Union
from typing_extensions import Annotated
from wandelbots_api_client.v2.models.add_trajectory_request import AddTrajectoryRequest
from wandelbots_api_client.v2.models.add_trajectory_response import AddTrajectoryResponse
from wandelbots_api_client.v2.models.execute_jogging_request import ExecuteJoggingRequest
from wandelbots_api_client.v2.models.execute_jogging_response import ExecuteJoggingResponse
from wandelbots_api_client.v2.models.execute_trajectory_request import ExecuteTrajectoryRequest
from wandelbots_api_client.v2.models.execute_trajectory_response import ExecuteTrajectoryResponse
from wandelbots_api_client.v2.models.list_trajectories_response import ListTrajectoriesResponse
from wandelbots_api_client.v2.models.move_to_trajectory_via_joint_ptp_response import MoveToTrajectoryViaJointPTPResponse
from wandelbots_api_client.v2.models.plan_trajectory_request import PlanTrajectoryRequest
from wandelbots_api_client.v2.models.plan_trajectory_response import PlanTrajectoryResponse

from wandelbots_api_client.v2.api_client import ApiClient, RequestSerialized
from wandelbots_api_client.v2.api_response import ApiResponse
from wandelbots_api_client.v2.rest import RESTResponseType

class MotionApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    async def clear_trajectories(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Clear Trajectories

        Clear the trajectory cache.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._clear_trajectories_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def clear_trajectories_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Clear Trajectories

        Clear the trajectory cache.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._clear_trajectories_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def clear_trajectories_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Clear Trajectories

        Clear the trajectory cache.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._clear_trajectories_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _clear_trajectories_serialize(
        self,
        cell,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/cells/{cell}/trajectories',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def create_trajectory(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        add_trajectory_request: AddTrajectoryRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddTrajectoryResponse:
        """Create Trajectory

        Posts and validates the data of a trajectory into the execution cache, rendering the trajectory executable. The response contains the result of the validation of the trajectory.  Validation can lead to three different results: - Fully valid: The whole trajectory can be executed from start to end. The response will contain an unique identifier which is used to move the robot. - Partially valid: Only parts of the trajectory can be executed. The response will contain an unique identifier to move the robot   and information about the failure for the part that is not executable. - Invalid: The trajectory can not be executed. The response will tell you the reason of failure.  If the trajectory is at least partially valid, the parts of the trajectory that are valid can be executed using the [executeTrajectory](executeTrajectory) endpoint.  The workflow is as follows:   - Generate a trajectory with [planTrajectory](planTrajectory) or your own motion planner,   - Send the trajectory to this endpoint to validate it and get a unique identifier for it,   - The unique identifier will appear in the list of available trajectories, see [listTrajectories](listTrajectories) endpoint, if it is at least partially executable.   - Move motion group to trajectory using the [executeToTrajectory](executeToTrajectory) endpoint.   - Execute your trajectory using the [executeTrajectory](executeTrajectory) endpoint. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param add_trajectory_request: (required)
        :type add_trajectory_request: AddTrajectoryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_trajectory_serialize(
            cell=cell,
            add_trajectory_request=add_trajectory_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddTrajectoryResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_trajectory_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        add_trajectory_request: AddTrajectoryRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddTrajectoryResponse]:
        """Create Trajectory

        Posts and validates the data of a trajectory into the execution cache, rendering the trajectory executable. The response contains the result of the validation of the trajectory.  Validation can lead to three different results: - Fully valid: The whole trajectory can be executed from start to end. The response will contain an unique identifier which is used to move the robot. - Partially valid: Only parts of the trajectory can be executed. The response will contain an unique identifier to move the robot   and information about the failure for the part that is not executable. - Invalid: The trajectory can not be executed. The response will tell you the reason of failure.  If the trajectory is at least partially valid, the parts of the trajectory that are valid can be executed using the [executeTrajectory](executeTrajectory) endpoint.  The workflow is as follows:   - Generate a trajectory with [planTrajectory](planTrajectory) or your own motion planner,   - Send the trajectory to this endpoint to validate it and get a unique identifier for it,   - The unique identifier will appear in the list of available trajectories, see [listTrajectories](listTrajectories) endpoint, if it is at least partially executable.   - Move motion group to trajectory using the [executeToTrajectory](executeToTrajectory) endpoint.   - Execute your trajectory using the [executeTrajectory](executeTrajectory) endpoint. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param add_trajectory_request: (required)
        :type add_trajectory_request: AddTrajectoryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_trajectory_serialize(
            cell=cell,
            add_trajectory_request=add_trajectory_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddTrajectoryResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_trajectory_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        add_trajectory_request: AddTrajectoryRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Trajectory

        Posts and validates the data of a trajectory into the execution cache, rendering the trajectory executable. The response contains the result of the validation of the trajectory.  Validation can lead to three different results: - Fully valid: The whole trajectory can be executed from start to end. The response will contain an unique identifier which is used to move the robot. - Partially valid: Only parts of the trajectory can be executed. The response will contain an unique identifier to move the robot   and information about the failure for the part that is not executable. - Invalid: The trajectory can not be executed. The response will tell you the reason of failure.  If the trajectory is at least partially valid, the parts of the trajectory that are valid can be executed using the [executeTrajectory](executeTrajectory) endpoint.  The workflow is as follows:   - Generate a trajectory with [planTrajectory](planTrajectory) or your own motion planner,   - Send the trajectory to this endpoint to validate it and get a unique identifier for it,   - The unique identifier will appear in the list of available trajectories, see [listTrajectories](listTrajectories) endpoint, if it is at least partially executable.   - Move motion group to trajectory using the [executeToTrajectory](executeToTrajectory) endpoint.   - Execute your trajectory using the [executeTrajectory](executeTrajectory) endpoint. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param add_trajectory_request: (required)
        :type add_trajectory_request: AddTrajectoryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_trajectory_serialize(
            cell=cell,
            add_trajectory_request=add_trajectory_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddTrajectoryResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_trajectory_serialize(
        self,
        cell,
        add_trajectory_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if add_trajectory_request is not None:
            _body_params = add_trajectory_request


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/cells/{cell}/trajectories',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def delete_trajectory(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        trajectory: Annotated[StrictStr, Field(description="This represents the unique identifier of a trajectory. Every executable or partially executable trajectory is cached and an unique identifier is returned. Indicate the unique identifier to execute the trajectory or retrieve information on the trajectory. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Trajectory

        Delete a previously created trajectory from cache. Use [listTrajectories](listTrajectories) to list all cached trajectories. Trajectories are removed automatically if the motion group or the corresponding controller is disconnected. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param trajectory: This represents the unique identifier of a trajectory. Every executable or partially executable trajectory is cached and an unique identifier is returned. Indicate the unique identifier to execute the trajectory or retrieve information on the trajectory.  (required)
        :type trajectory: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_trajectory_serialize(
            cell=cell,
            trajectory=trajectory,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_trajectory_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        trajectory: Annotated[StrictStr, Field(description="This represents the unique identifier of a trajectory. Every executable or partially executable trajectory is cached and an unique identifier is returned. Indicate the unique identifier to execute the trajectory or retrieve information on the trajectory. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Trajectory

        Delete a previously created trajectory from cache. Use [listTrajectories](listTrajectories) to list all cached trajectories. Trajectories are removed automatically if the motion group or the corresponding controller is disconnected. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param trajectory: This represents the unique identifier of a trajectory. Every executable or partially executable trajectory is cached and an unique identifier is returned. Indicate the unique identifier to execute the trajectory or retrieve information on the trajectory.  (required)
        :type trajectory: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_trajectory_serialize(
            cell=cell,
            trajectory=trajectory,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_trajectory_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        trajectory: Annotated[StrictStr, Field(description="This represents the unique identifier of a trajectory. Every executable or partially executable trajectory is cached and an unique identifier is returned. Indicate the unique identifier to execute the trajectory or retrieve information on the trajectory. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Trajectory

        Delete a previously created trajectory from cache. Use [listTrajectories](listTrajectories) to list all cached trajectories. Trajectories are removed automatically if the motion group or the corresponding controller is disconnected. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param trajectory: This represents the unique identifier of a trajectory. Every executable or partially executable trajectory is cached and an unique identifier is returned. Indicate the unique identifier to execute the trajectory or retrieve information on the trajectory.  (required)
        :type trajectory: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_trajectory_serialize(
            cell=cell,
            trajectory=trajectory,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_trajectory_serialize(
        self,
        cell,
        trajectory,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if trajectory is not None:
            _path_params['trajectory'] = trajectory
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/cells/{cell}/trajectories/{trajectory}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def execute_jogging(self, cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")], client_request_generator: Callable[[AsyncGenerator[ExecuteJoggingResponse, None]], AsyncGenerator[ExecuteJoggingRequest, None]]) -> None:  # noqa: E501
        """Execute Jogging  # noqa: E501

        > **Note:** This is a websocket endpoint.  Provides execution control over a dynamically adaptable jogging motion for a motion group.  Jogging describes controlling a motion group by sending real-time commands to move either its joints or the TCP (Tool Center Point). The commands contain target velocities that may change at any time during execution, so the resulting motion cannot be computed upfront.  ### Preconditions  The motion group is not moved by any other endpoint.  ### Requests  #### 1. Send InitializeJoggingRequest to configure the jogging.  Sets robot controller mode to control mode. Sets rate and coordinate system for the jogging response.  #### 2. Send JointVelocityRequest or TcpVelocityRequest to start the jogging motion.  #### 3. Change or stop the jogging motion  - Change the jogging direction and/or velocity during the jogging motion with JointVelocityRequest or TcpVelocityRequest. - To stop the jogging motion, send zero velocities via either request.  ### Responses  - InitializeJoggingResponse is sent to signal the success or failure of the InitializeJoggingRequest. - Jogging responses are streamed continuously after an InitializeJoggingRequest is processed.   Jogging responses contain the robot controller state and the state of the jogging control. - JoggingErrorResponse with error details is sent in case of an unexpected error, e.g., controller disconnects during jogging.  ### Tips and Tricks  - In the JoggingResponse, verify that the robot control is in the desired state, e.g. standstill, with JoggingState. - Ensure that the websocket connection remains open until the jogging motion is stopped to avoid unexpected stops.   # noqa: E501
        :param client_request_generator: An AsyncGenerator that yields request of type ExecuteJoggingRequest and takes an AsyncGenerator of ExecuteJoggingResponse as an input argument (required)
        :info All responses from the server will be yielded to client_request_generator through the (AsyncGenerator[ExecuteJoggingResponse, None])
        :type AsyncGenerator[ExecuteJoggingRequest, None]
        """
        def format_path_parameters(path):
            # Find all substrings that are enclosed in brackets
            bracket_contents = re.findall(r'\{(.*?)\}', path)

            # For each found substring, alter it to match the python variable name
            for content in bracket_contents:
                content = "{" + content + "}"
                modified_content = humps.dekebabize(content)
                path = path.replace(content, modified_content)

            return path

        async def iterate_responses(ws) -> AsyncGenerator[ExecuteJoggingResponse, None]:
            async for response in ws:
                if "Cancelled on the server side" in response:
                    break
                response_data = json.loads(response)
                if "result" not in response_data:
                    raise Exception(response_data)
                yield ExecuteJoggingResponse.from_dict(response_data["result"])

        path = format_path_parameters("/cells/{cell}/execution/jogging")
        path = path.format(cell=cell,)

        headers = websockets.Headers()
        tmp_host = self.api_client.configuration.host
        if self.api_client.configuration.host.startswith("https://"):
            # Basic Auth
            if self.api_client.configuration.username:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{self.api_client.configuration.username}:{self.api_client.configuration.password}@{tmp_host}"

            # OAuth2
            elif self.api_client.configuration.access_token:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{tmp_host}"
                headers = websockets.Headers([
                    ("Authorization", f"Bearer {self.api_client.configuration.access_token}")
                ])
        else:
            tmp_host = tmp_host.replace("http://", "ws://")

        full_url = furl(tmp_host + path)

        async with websockets.connect(full_url.url, open_timeout=10, additional_headers=headers) as websocket:
            async for request in client_request_generator(iterate_responses(websocket)):
                await websocket.send(request.model_dump_json(by_alias=True))


    @validate_call
    async def execute_to_trajectory(self, cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")], trajectory: Annotated[StrictStr, Field(description="This represents the unique identifier of a trajectory. Every executable or partially executable trajectory is cached and an unique identifier is returned. Indicate the unique identifier to execute the trajectory or retrieve information on the trajectory. ")], location_on_trajectory: Union[StrictFloat, StrictInt], override_joint_velocity_limits: Annotated[Optional[List[Union[StrictFloat, StrictInt]]], Field(description="The joint velocity limits for the p2p movement to a previously added trajectory.")] = None, override_joint_acceleration_limits: Annotated[Optional[List[Union[StrictFloat, StrictInt]]], Field(description="The joint acceleration limits for the p2p movement to a previously added trajectory.")] = None, override_tcp_velocity_limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Maximum allowed TCP velocity in [mm/s].")] = None, override_tcp_acceleration_limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Maximum allowed TCP acceleration in [mm/s^2].")] = None, override_tcp_orientation_velocity_limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Maximum allowed TCP rotation velocity in [rad/s].")] = None, override_tcp_orientation_acceleration_limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Maximum allowed TCP rotation acceleration in [rad/s^2].")] = None, responses_coordinate_system: Optional[StrictStr] = None) -> AsyncGenerator[MoveToTrajectoryViaJointPTPResponse, None]:  # noqa: E501
        """Move to Trajectory  # noqa: E501

        Request to move the motion group via joint point-to-point to a given location on a trajectory.  To start moving along a trajectory from an arbitrary location, the current joint positions must match the joint positions of the trajectory at the given location.  > **Note:** To abort the movement, the connection needs to be closed.   # noqa: E501
        :param request: A ExecuteToTrajectoryRequest
        :info All responses from the server will be yielded
        :type ExecuteToTrajectoryRequest
        """
        def format_path_parameters(path):
            # Find all substrings that are enclosed in brackets
            bracket_contents = re.findall(r'\{(.*?)\}', path)

            # For each found substring, replace underscores with spaces
            for content in bracket_contents:
                content = "{" + content + "}"
                modified_content = humps.dekebabize(content)
                path = path.replace(content, modified_content)

            return path

        def append_parameter_connector(url_schema):
            if not "?" in url_schema:
                url_schema += "?"
            else:
                url_schema += "&"
            return url_schema

        path = format_path_parameters("/cells/{cell}/trajectories/{trajectory}/execution/to-trajectory")
        path = path.format(cell=cell,trajectory=trajectory,)

        headers = websockets.Headers()
        tmp_host = self.api_client.configuration.host
        if self.api_client.configuration.host.startswith("https://"):
            # Basic Auth
            if self.api_client.configuration.username:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{self.api_client.configuration.username}:{self.api_client.configuration.password}@{tmp_host}"

            # OAuth2
            elif self.api_client.configuration.access_token:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{tmp_host}"
                headers = websockets.Headers([
                    ("Authorization", f"Bearer {self.api_client.configuration.access_token}")
                ])
        else:
            tmp_host = tmp_host.replace("http://", "ws://")

        url_schema = tmp_host + path
        if locals().get("location_on_trajectory") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(location_on_trajectory, list):
              url_schema += "&".join(["location_on_trajectory=" + s for s in location_on_trajectory])
            else:
              url_schema += "location_on_trajectory="+str(location_on_trajectory)
        if locals().get("override_joint_velocity_limits") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(override_joint_velocity_limits, list):
              url_schema += "&".join(["override_joint_velocity_limits=" + s for s in override_joint_velocity_limits])
            else:
              url_schema += "override_joint_velocity_limits="+str(override_joint_velocity_limits)
        if locals().get("override_joint_acceleration_limits") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(override_joint_acceleration_limits, list):
              url_schema += "&".join(["override_joint_acceleration_limits=" + s for s in override_joint_acceleration_limits])
            else:
              url_schema += "override_joint_acceleration_limits="+str(override_joint_acceleration_limits)
        if locals().get("override_tcp_velocity_limit") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(override_tcp_velocity_limit, list):
              url_schema += "&".join(["override_tcp_velocity_limit=" + s for s in override_tcp_velocity_limit])
            else:
              url_schema += "override_tcp_velocity_limit="+str(override_tcp_velocity_limit)
        if locals().get("override_tcp_acceleration_limit") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(override_tcp_acceleration_limit, list):
              url_schema += "&".join(["override_tcp_acceleration_limit=" + s for s in override_tcp_acceleration_limit])
            else:
              url_schema += "override_tcp_acceleration_limit="+str(override_tcp_acceleration_limit)
        if locals().get("override_tcp_orientation_velocity_limit") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(override_tcp_orientation_velocity_limit, list):
              url_schema += "&".join(["override_tcp_orientation_velocity_limit=" + s for s in override_tcp_orientation_velocity_limit])
            else:
              url_schema += "override_tcp_orientation_velocity_limit="+str(override_tcp_orientation_velocity_limit)
        if locals().get("override_tcp_orientation_acceleration_limit") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(override_tcp_orientation_acceleration_limit, list):
              url_schema += "&".join(["override_tcp_orientation_acceleration_limit=" + s for s in override_tcp_orientation_acceleration_limit])
            else:
              url_schema += "override_tcp_orientation_acceleration_limit="+str(override_tcp_orientation_acceleration_limit)
        if locals().get("responses_coordinate_system") is not None:
            url_schema = append_parameter_connector(url_schema)
            if isinstance(responses_coordinate_system, list):
              url_schema += "&".join(["responses_coordinate_system=" + s for s in responses_coordinate_system])
            else:
              url_schema += "responses_coordinate_system="+str(responses_coordinate_system)
        full_url = furl(url_schema)

        async with websockets.connect(full_url.url, open_timeout=10, additional_headers=headers) as websocket:
            try:
                async for response in websocket:
                    response_data = json.loads(response)
                    if "result" not in response_data:
                        raise Exception(response_data)
                    yield MoveToTrajectoryViaJointPTPResponse.from_dict(response_data["result"])
            except websockets.exceptions.ConnectionClosed:
                return


    @validate_call
    async def execute_trajectory(self, cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")], client_request_generator: Callable[[AsyncGenerator[ExecuteTrajectoryResponse, None]], AsyncGenerator[ExecuteTrajectoryRequest, None]]) -> None:  # noqa: E501
        """Execute Trajectory  # noqa: E501

        > **Note:** This is a websocket endpoint.  Provides execution control over a previously planned trajectory. Enables the caller to attach I/O actions to the trajectory.  Understanding the concept of location:   The location or path parameter specifies the exact position along a trajectory.   The location is a scalar value that ranges from 0 to `n`,   where `n` denotes the number of motion commands, or trajectory segments, e.g. line, p2p, etc. See [planMotion](planMotion).   Each integer value of the location corresponds to one motion command, e.g. 3.0 to 3.999 could be a line.  ### Preconditions  - The motion group's control mode is not claimed by any other endpoint. - The motion group's joint position are at start location specified with InitializeMovementRequest. - Use [executeToTrajectory](executeToTrajectory) to move the robot to the start location.  ### Requests  #### 1. Send InitializeMovementRequest to lock the trajectory to this connection   The following actions are executed:   - Sets robot controller mode to control mode,   - Sets start location of the execution    Keep in mind that only a single trajectory can be locked to a websocket connection at a time and not unlocked anymore.   To execute another trajectory, a new connection must be established.  #### 2. Send StartMovementRequest to start the movement  Sets direction of movement, default is forward.  #### **Optional**  - To pause, send PauseMovementRequest before the movement has reached its end location. - Change the movement's velocity with PlaybackSpeedRequest after initializing the movement with InitializeMovementRequest.  ### Responses  - InitializeMovementResponse is sent to signal the success or failure of the InitializeMovementRequest. - Movement responses are streamed after a StartMovementRequest successfully started the movement.   Movement responses are streamed in a rate that is defined as the multiple of the controller step-rate closest to   but not exceeding the rate configured by InitializeMovementRequest. - Standstill reponse  is sent once the movement has finished or has come to a standstill due to a pause. - PauseMovementResponse is sent to signal the success of the PauseMovementRequest. It does not signal the end of the movement.   End of movement is signaled by Standstill reponse . - PlaybackSpeedResponse is sent to signal the success of the PlaybackSpeedRequest. - MovementError with error details is sent in case of an unexpected error, e.g. controller disconnects during movement.  ### Tips and Tricks  - A movement can be paused and resumed by sending PauseMovementRequest and StartMovementRequest. - Send PlaybackSpeedRequest before StartMovementRequest to reduce the velocity of the movement before it starts. - Send PlaybackSpeedRequest repeatedly to implement a slider. The velocity of the motion group can be adjusted with each controller step. Therefore, if your app needs a slider-like UI to alter the velocity of a currently running movement, you can send PlaybackSpeedRequest with different speed values repeatedly during the movement. - A closed trajectory (end and start joint position are equal) can be repeated by sending StartMovementRequest after the movement has finished.   # noqa: E501
        :param client_request_generator: An AsyncGenerator that yields request of type ExecuteTrajectoryRequest and takes an AsyncGenerator of ExecuteTrajectoryResponse as an input argument (required)
        :info All responses from the server will be yielded to client_request_generator through the (AsyncGenerator[ExecuteTrajectoryResponse, None])
        :type AsyncGenerator[ExecuteTrajectoryRequest, None]
        """
        def format_path_parameters(path):
            # Find all substrings that are enclosed in brackets
            bracket_contents = re.findall(r'\{(.*?)\}', path)

            # For each found substring, alter it to match the python variable name
            for content in bracket_contents:
                content = "{" + content + "}"
                modified_content = humps.dekebabize(content)
                path = path.replace(content, modified_content)

            return path

        async def iterate_responses(ws) -> AsyncGenerator[ExecuteTrajectoryResponse, None]:
            async for response in ws:
                if "Cancelled on the server side" in response:
                    break
                response_data = json.loads(response)
                if "result" not in response_data:
                    raise Exception(response_data)
                yield ExecuteTrajectoryResponse.from_dict(response_data["result"])

        path = format_path_parameters("/cells/{cell}/execution/trajectory")
        path = path.format(cell=cell,)

        headers = websockets.Headers()
        tmp_host = self.api_client.configuration.host
        if self.api_client.configuration.host.startswith("https://"):
            # Basic Auth
            if self.api_client.configuration.username:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{self.api_client.configuration.username}:{self.api_client.configuration.password}@{tmp_host}"

            # OAuth2
            elif self.api_client.configuration.access_token:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{tmp_host}"
                headers = websockets.Headers([
                    ("Authorization", f"Bearer {self.api_client.configuration.access_token}")
                ])
        else:
            tmp_host = tmp_host.replace("http://", "ws://")

        full_url = furl(tmp_host + path)

        async with websockets.connect(full_url.url, open_timeout=10, additional_headers=headers) as websocket:
            async for request in client_request_generator(iterate_responses(websocket)):
                await websocket.send(request.model_dump_json(by_alias=True))


    @validate_call
    async def get_planning_motion_group_models(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[str]:
        """Motion Group Models for Planning

        Returns motion group models that are supported for planning. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_planning_motion_group_models_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[str]",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_planning_motion_group_models_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[str]]:
        """Motion Group Models for Planning

        Returns motion group models that are supported for planning. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_planning_motion_group_models_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[str]",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_planning_motion_group_models_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Motion Group Models for Planning

        Returns motion group models that are supported for planning. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_planning_motion_group_models_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[str]",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_planning_motion_group_models_serialize(
        self,
        cell,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/motion-planning/motion-group-models',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def list_trajectories(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListTrajectoriesResponse:
        """List Trajectories

        List currently cached trajectories. Use [addTrajectory](addTrajectory) to add a new trajectory. Adding trajectories is necessary to execute them. Trajectories are removed if the corresponding motion group or controller disconnects. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_trajectories_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTrajectoriesResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_trajectories_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListTrajectoriesResponse]:
        """List Trajectories

        List currently cached trajectories. Use [addTrajectory](addTrajectory) to add a new trajectory. Adding trajectories is necessary to execute them. Trajectories are removed if the corresponding motion group or controller disconnects. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_trajectories_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTrajectoriesResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_trajectories_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Trajectories

        List currently cached trajectories. Use [addTrajectory](addTrajectory) to add a new trajectory. Adding trajectories is necessary to execute them. Trajectories are removed if the corresponding motion group or controller disconnects. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_trajectories_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTrajectoriesResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_trajectories_serialize(
        self,
        cell,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/trajectories',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def plan_trajectory(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        plan_trajectory_request: Optional[PlanTrajectoryRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PlanTrajectoryResponse:
        """Plan Trajectory

        Plans a new trajectory for a single motion group.  Describe the trajectory as a sequence of motion commands that the robots TCP should follow.  Use the following workflow to execute a planned trajectory: 1. Plan a trajectory. 2. Validate and load the planned trajectory using the [loadPlannedMotion](loadPlannedMotion) endpoint. 3. Execute the loaded trajectory using the [streamMove](streamMove) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param plan_trajectory_request:
        :type plan_trajectory_request: PlanTrajectoryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._plan_trajectory_serialize(
            cell=cell,
            plan_trajectory_request=plan_trajectory_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanTrajectoryResponse",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def plan_trajectory_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        plan_trajectory_request: Optional[PlanTrajectoryRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PlanTrajectoryResponse]:
        """Plan Trajectory

        Plans a new trajectory for a single motion group.  Describe the trajectory as a sequence of motion commands that the robots TCP should follow.  Use the following workflow to execute a planned trajectory: 1. Plan a trajectory. 2. Validate and load the planned trajectory using the [loadPlannedMotion](loadPlannedMotion) endpoint. 3. Execute the loaded trajectory using the [streamMove](streamMove) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param plan_trajectory_request:
        :type plan_trajectory_request: PlanTrajectoryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._plan_trajectory_serialize(
            cell=cell,
            plan_trajectory_request=plan_trajectory_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanTrajectoryResponse",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def plan_trajectory_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        plan_trajectory_request: Optional[PlanTrajectoryRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Plan Trajectory

        Plans a new trajectory for a single motion group.  Describe the trajectory as a sequence of motion commands that the robots TCP should follow.  Use the following workflow to execute a planned trajectory: 1. Plan a trajectory. 2. Validate and load the planned trajectory using the [loadPlannedMotion](loadPlannedMotion) endpoint. 3. Execute the loaded trajectory using the [streamMove](streamMove) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param plan_trajectory_request:
        :type plan_trajectory_request: PlanTrajectoryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._plan_trajectory_serialize(
            cell=cell,
            plan_trajectory_request=plan_trajectory_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanTrajectoryResponse",
            '404': None,
            '422': "HTTPValidationError",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _plan_trajectory_serialize(
        self,
        cell,
        plan_trajectory_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if plan_trajectory_request is not None:
            _body_params = plan_trajectory_request


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/cells/{cell}/motion-planning/plan-trajectory',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


