# coding: utf-8

"""
    Wandelbots Nova API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from furl import furl
import json
import humps
import re
import warnings
import websockets
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, AsyncGenerator, Callable, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated
from urllib.parse import quote

from pydantic import Field, StrictStr, field_validator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated
from wandelbots_api_client.v2.models.io_direction import IODirection
from wandelbots_api_client.v2.models.io_value_type import IOValueType
from wandelbots_api_client.v2.models.ios import IOs
from wandelbots_api_client.v2.models.motion_group_infos import MotionGroupInfos
from wandelbots_api_client.v2.models.motion_group_joints import MotionGroupJoints
from wandelbots_api_client.v2.models.set_io_values_request_inner import SetIOValuesRequestInner

from wandelbots_api_client.v2.api_client import ApiClient, RequestSerialized
from wandelbots_api_client.v2.api_response import ApiResponse
from wandelbots_api_client.v2.rest import RESTResponseType

class VirtualRobotApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    async def get_motion_group_state(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        motion_group: Annotated[StrictStr, Field(description="The motion-group identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MotionGroupJoints:
        """Get Motion Group State

        Get the current motion group state which provides values for the joints' position, velocity and acceleration. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param motion_group: The motion-group identifier. (required)
        :type motion_group: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_group_state_serialize(
            cell=cell,
            controller=controller,
            motion_group=motion_group,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MotionGroupJoints",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_motion_group_state_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        motion_group: Annotated[StrictStr, Field(description="The motion-group identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MotionGroupJoints]:
        """Get Motion Group State

        Get the current motion group state which provides values for the joints' position, velocity and acceleration. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param motion_group: The motion-group identifier. (required)
        :type motion_group: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_group_state_serialize(
            cell=cell,
            controller=controller,
            motion_group=motion_group,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MotionGroupJoints",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_motion_group_state_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        motion_group: Annotated[StrictStr, Field(description="The motion-group identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Motion Group State

        Get the current motion group state which provides values for the joints' position, velocity and acceleration. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param motion_group: The motion-group identifier. (required)
        :type motion_group: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_group_state_serialize(
            cell=cell,
            controller=controller,
            motion_group=motion_group,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MotionGroupJoints",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_motion_group_state_serialize(
        self,
        cell,
        controller,
        motion_group,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if controller is not None:
            _path_params['controller'] = controller
        if motion_group is not None:
            _path_params['motion-group'] = motion_group
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/controllers/{controller}/teach-pendant/motion-groups/{motion-group}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def get_motion_groups(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MotionGroupInfos:
        """Motion Group Description

        Gets information on the motion group. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_groups_serialize(
            cell=cell,
            controller=controller,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MotionGroupInfos",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_motion_groups_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MotionGroupInfos]:
        """Motion Group Description

        Gets information on the motion group. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_groups_serialize(
            cell=cell,
            controller=controller,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MotionGroupInfos",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_motion_groups_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Motion Group Description

        Gets information on the motion group. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_groups_serialize(
            cell=cell,
            controller=controller,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MotionGroupInfos",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_motion_groups_serialize(
        self,
        cell,
        controller,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if controller is not None:
            _path_params['controller'] = controller
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/controllers/{controller}/teach-pendant/motion-groups',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def list_ios(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        ios: Optional[List[StrictStr]] = None,
        direction: Annotated[Optional[IODirection], Field(description="Return only inputs/outputs with the specified direction. ")] = None,
        value_type: Annotated[Optional[IOValueType], Field(description="Return only inputs/outputs with the specified value type. ")] = None,
        prefix: Annotated[Optional[StrictStr], Field(description="Return only inputs/outputs with the specified prefix of unique identifier. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> IOs:
        """Get Inputs/Outputs

        Lists the inputs/outputs of the virtual controller. Every input/output contains the description and the value.  Each input/output has a unique identifier. If no identifiers are specified in the request, the full list of available inputs/outputs is retrieved by this endpoint. As a virtual robot can have up to thousand inputs/outputs, be ready to handle a large response. Use [List Descriptions](List Descriptions) to get a detailed description of an input/output. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param ios:
        :type ios: List[str]
        :param direction: Return only inputs/outputs with the specified direction. 
        :type direction: IODirection
        :param value_type: Return only inputs/outputs with the specified value type. 
        :type value_type: IOValueType
        :param prefix: Return only inputs/outputs with the specified prefix of unique identifier. 
        :type prefix: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_ios_serialize(
            cell=cell,
            controller=controller,
            ios=ios,
            direction=direction,
            value_type=value_type,
            prefix=prefix,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "IOs",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_ios_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        ios: Optional[List[StrictStr]] = None,
        direction: Annotated[Optional[IODirection], Field(description="Return only inputs/outputs with the specified direction. ")] = None,
        value_type: Annotated[Optional[IOValueType], Field(description="Return only inputs/outputs with the specified value type. ")] = None,
        prefix: Annotated[Optional[StrictStr], Field(description="Return only inputs/outputs with the specified prefix of unique identifier. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[IOs]:
        """Get Inputs/Outputs

        Lists the inputs/outputs of the virtual controller. Every input/output contains the description and the value.  Each input/output has a unique identifier. If no identifiers are specified in the request, the full list of available inputs/outputs is retrieved by this endpoint. As a virtual robot can have up to thousand inputs/outputs, be ready to handle a large response. Use [List Descriptions](List Descriptions) to get a detailed description of an input/output. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param ios:
        :type ios: List[str]
        :param direction: Return only inputs/outputs with the specified direction. 
        :type direction: IODirection
        :param value_type: Return only inputs/outputs with the specified value type. 
        :type value_type: IOValueType
        :param prefix: Return only inputs/outputs with the specified prefix of unique identifier. 
        :type prefix: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_ios_serialize(
            cell=cell,
            controller=controller,
            ios=ios,
            direction=direction,
            value_type=value_type,
            prefix=prefix,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "IOs",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_ios_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        ios: Optional[List[StrictStr]] = None,
        direction: Annotated[Optional[IODirection], Field(description="Return only inputs/outputs with the specified direction. ")] = None,
        value_type: Annotated[Optional[IOValueType], Field(description="Return only inputs/outputs with the specified value type. ")] = None,
        prefix: Annotated[Optional[StrictStr], Field(description="Return only inputs/outputs with the specified prefix of unique identifier. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Inputs/Outputs

        Lists the inputs/outputs of the virtual controller. Every input/output contains the description and the value.  Each input/output has a unique identifier. If no identifiers are specified in the request, the full list of available inputs/outputs is retrieved by this endpoint. As a virtual robot can have up to thousand inputs/outputs, be ready to handle a large response. Use [List Descriptions](List Descriptions) to get a detailed description of an input/output. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param ios:
        :type ios: List[str]
        :param direction: Return only inputs/outputs with the specified direction. 
        :type direction: IODirection
        :param value_type: Return only inputs/outputs with the specified value type. 
        :type value_type: IOValueType
        :param prefix: Return only inputs/outputs with the specified prefix of unique identifier. 
        :type prefix: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_ios_serialize(
            cell=cell,
            controller=controller,
            ios=ios,
            direction=direction,
            value_type=value_type,
            prefix=prefix,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "IOs",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_ios_serialize(
        self,
        cell,
        controller,
        ios,
        direction,
        value_type,
        prefix,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'ios': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if controller is not None:
            _path_params['controller'] = controller
        # process the query parameters
        if ios is not None:
            
            _query_params.append(('ios', ios))
            
        if direction is not None:
            
            _query_params.append(('direction', direction.value))
            
        if value_type is not None:
            
            _query_params.append(('value_type', value_type.value))
            
        if prefix is not None:
            
            _query_params.append(('prefix', prefix))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/controllers/{controller}/teach-pendant/ios',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def set_io_values(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        set_io_values_request_inner: List[SetIOValuesRequestInner],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Set Input/Ouput Values

        Sets a list of values of a virtual controller inputs/outputs. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param set_io_values_request_inner: (required)
        :type set_io_values_request_inner: List[SetIOValuesRequestInner]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_io_values_serialize(
            cell=cell,
            controller=controller,
            set_io_values_request_inner=set_io_values_request_inner,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def set_io_values_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        set_io_values_request_inner: List[SetIOValuesRequestInner],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Set Input/Ouput Values

        Sets a list of values of a virtual controller inputs/outputs. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param set_io_values_request_inner: (required)
        :type set_io_values_request_inner: List[SetIOValuesRequestInner]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_io_values_serialize(
            cell=cell,
            controller=controller,
            set_io_values_request_inner=set_io_values_request_inner,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def set_io_values_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        set_io_values_request_inner: List[SetIOValuesRequestInner],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Set Input/Ouput Values

        Sets a list of values of a virtual controller inputs/outputs. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param set_io_values_request_inner: (required)
        :type set_io_values_request_inner: List[SetIOValuesRequestInner]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_io_values_serialize(
            cell=cell,
            controller=controller,
            set_io_values_request_inner=set_io_values_request_inner,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _set_io_values_serialize(
        self,
        cell,
        controller,
        set_io_values_request_inner,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'SetIOValuesRequestInner': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if controller is not None:
            _path_params['controller'] = controller
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if set_io_values_request_inner is not None:
            _body_params = set_io_values_request_inner


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/cells/{cell}/controllers/{controller}/teach-pendant/ios',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def set_motion_group_state(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        motion_group: Annotated[StrictStr, Field(description="The motion-group identifier.")],
        motion_group_joints: MotionGroupJoints,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Set Motion Group State

        Sets the values for joint position, joint velocity or joint acceleration of a motion group state. The values are immediately applied to the joints of the motion group. We recommend to only use the endpoint when the motion group is in monitor mode. In case the motion group is controlled, currently jogging or planning motions, the values are overridden by the controller or an error may occur. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param motion_group: The motion-group identifier. (required)
        :type motion_group: str
        :param motion_group_joints: (required)
        :type motion_group_joints: MotionGroupJoints
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_motion_group_state_serialize(
            cell=cell,
            controller=controller,
            motion_group=motion_group,
            motion_group_joints=motion_group_joints,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def set_motion_group_state_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        motion_group: Annotated[StrictStr, Field(description="The motion-group identifier.")],
        motion_group_joints: MotionGroupJoints,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Set Motion Group State

        Sets the values for joint position, joint velocity or joint acceleration of a motion group state. The values are immediately applied to the joints of the motion group. We recommend to only use the endpoint when the motion group is in monitor mode. In case the motion group is controlled, currently jogging or planning motions, the values are overridden by the controller or an error may occur. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param motion_group: The motion-group identifier. (required)
        :type motion_group: str
        :param motion_group_joints: (required)
        :type motion_group_joints: MotionGroupJoints
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_motion_group_state_serialize(
            cell=cell,
            controller=controller,
            motion_group=motion_group,
            motion_group_joints=motion_group_joints,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def set_motion_group_state_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        controller: Annotated[StrictStr, Field(description="Unique identifier to address a controller in the cell.")],
        motion_group: Annotated[StrictStr, Field(description="The motion-group identifier.")],
        motion_group_joints: MotionGroupJoints,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Set Motion Group State

        Sets the values for joint position, joint velocity or joint acceleration of a motion group state. The values are immediately applied to the joints of the motion group. We recommend to only use the endpoint when the motion group is in monitor mode. In case the motion group is controlled, currently jogging or planning motions, the values are overridden by the controller or an error may occur. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param controller: Unique identifier to address a controller in the cell. (required)
        :type controller: str
        :param motion_group: The motion-group identifier. (required)
        :type motion_group: str
        :param motion_group_joints: (required)
        :type motion_group_joints: MotionGroupJoints
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_motion_group_state_serialize(
            cell=cell,
            controller=controller,
            motion_group=motion_group,
            motion_group_joints=motion_group_joints,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _set_motion_group_state_serialize(
        self,
        cell,
        controller,
        motion_group,
        motion_group_joints,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if controller is not None:
            _path_params['controller'] = controller
        if motion_group is not None:
            _path_params['motion-group'] = motion_group
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if motion_group_joints is not None:
            _body_params = motion_group_joints


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/cells/{cell}/controllers/{controller}/teach-pendant/motion-groups/{motion-group}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


