# coding: utf-8

"""
    Wandelbots Nova API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class RobotSystemMode(str, Enum):
    """
    The system mode of the robot system.  ### ROBOT_SYSTEM_MODE_UNDEFINED  Indicates that the robot controller is currently performing a mode transition.  ### ROBOT_SYSTEM_MODE_DISCONNECT  There is no communication with the robot controller at all. All connections are closed. No command is sent to the robot controller while in this mode. No input/output interaction is possible in this mode! All move requests will be rejected in this mode!  ### ROBOT_SYSTEM_MODE_MONITOR  A connection to the robot controller is established to only read the robot controller state. No command is sent to the robot controller while in this mode. It is possible to receive input/output information. All move requests will be rejected in this mode!  ### ROBOT_SYSTEM_MODE_CONTROL  An active connection is established with the robot controller and the robot system is cyclic commanded to stay in its actual position. The robot controller state is received in the cycle time of the robot controller. Requests via the MotionService and JoggingService will be processed and executed in this mode. Input/Output interaction is possible in this mode! **In this mode the robot system can be commanded to move.**  ### ROBOT_SYSTEM_MODE_FREE_DRIVE  Like ROBOT_SYSTEM_MODE_MONITOR a connection to the robot controller is established to only read the robot controller state. The difference is that the motion groups can be moved by the user (Free Drive). Thus, the servo motors are turned on. All move requests will be rejected in this mode! **This mode is not supported by every robot!** Use [getSupportedModes](getSupportedModes) to evaluate if the device support free drive. 
    """

    """
    allowed enum values
    """
    ROBOT_SYSTEM_MODE_UNDEFINED = 'ROBOT_SYSTEM_MODE_UNDEFINED'
    ROBOT_SYSTEM_MODE_DISCONNECT = 'ROBOT_SYSTEM_MODE_DISCONNECT'
    ROBOT_SYSTEM_MODE_MONITOR = 'ROBOT_SYSTEM_MODE_MONITOR'
    ROBOT_SYSTEM_MODE_CONTROL = 'ROBOT_SYSTEM_MODE_CONTROL'
    ROBOT_SYSTEM_MODE_FREE_DRIVE = 'ROBOT_SYSTEM_MODE_FREE_DRIVE'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of RobotSystemMode from a JSON string"""
        return cls(json.loads(json_str))


