# coding: utf-8

"""
    Wandelbots Nova API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.models.collection_value import CollectionValue
from typing import Optional, Set
from typing_extensions import Self

class CodeWithArguments(BaseModel):
    """
    CodeWithArguments
    """ # noqa: E501
    code: StrictStr = Field(description="Wandelscript code string which describes a Wandelscript Program as content/json.")
    initial_state: Optional[Dict[str, CollectionValue]] = None
    __properties: ClassVar[List[str]] = ["code", "initial_state"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodeWithArguments from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in initial_state (dict)
        _field_dict = {}
        if self.initial_state:
            for _key in self.initial_state:
                if self.initial_state[_key]:
                    _field_dict[_key] = self.initial_state[_key].to_dict()
            _dict['initial_state'] = _field_dict
        # set to None if initial_state (nullable) is None
        # and model_fields_set contains the field
        if self.initial_state is None and "initial_state" in self.model_fields_set:
            _dict['initial_state'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodeWithArguments from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "code": obj.get("code"),
            "initial_state": dict(
                (_k, CollectionValue.from_dict(_v))
                for _k, _v in obj["initial_state"].items()
            )
            if obj.get("initial_state") is not None
            else None
        })
        return _obj


