# coding: utf-8

"""
    Wandelbots Nova API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.collision2 import Collision2
from wandelbots_api_client.v2.models.inconsitent_trajectory_size import InconsitentTrajectorySize
from wandelbots_api_client.v2.models.invalid_dof import InvalidDof
from wandelbots_api_client.v2.models.joint_limit_exceeded import JointLimitExceeded
from wandelbots_api_client.v2.models.nan_value import NanValue
from wandelbots_api_client.v2.models.tcp_required import TcpRequired
from wandelbots_api_client.v2.models.torque_exceeded import TorqueExceeded
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ADDTRAJECTORYERRORDATA_ONE_OF_SCHEMAS = ["Collision2", "InconsitentTrajectorySize", "InvalidDof", "JointLimitExceeded", "NanValue", "TcpRequired", "TorqueExceeded"]

class AddTrajectoryErrorData(BaseModel):
    """
    AddTrajectoryErrorData
    """
    # data type: TcpRequired
    oneof_schema_1_validator: Optional[TcpRequired] = None
    # data type: InconsitentTrajectorySize
    oneof_schema_2_validator: Optional[InconsitentTrajectorySize] = None
    # data type: JointLimitExceeded
    oneof_schema_3_validator: Optional[JointLimitExceeded] = None
    # data type: Collision2
    oneof_schema_4_validator: Optional[Collision2] = None
    # data type: TorqueExceeded
    oneof_schema_5_validator: Optional[TorqueExceeded] = None
    # data type: InvalidDof
    oneof_schema_6_validator: Optional[InvalidDof] = None
    # data type: NanValue
    oneof_schema_7_validator: Optional[NanValue] = None
    actual_instance: Optional[Union[Collision2, InconsitentTrajectorySize, InvalidDof, JointLimitExceeded, NanValue, TcpRequired, TorqueExceeded]] = None
    one_of_schemas: Set[str] = { "Collision2", "InconsitentTrajectorySize", "InvalidDof", "JointLimitExceeded", "NanValue", "TcpRequired", "TorqueExceeded" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = AddTrajectoryErrorData.model_construct()
        error_messages = []
        match = 0
        # validate data type: TcpRequired
        if not isinstance(v, TcpRequired):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TcpRequired`")
        else:
            match += 1
        # validate data type: InconsitentTrajectorySize
        if not isinstance(v, InconsitentTrajectorySize):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InconsitentTrajectorySize`")
        else:
            match += 1
        # validate data type: JointLimitExceeded
        if not isinstance(v, JointLimitExceeded):
            error_messages.append(f"Error! Input type `{type(v)}` is not `JointLimitExceeded`")
        else:
            match += 1
        # validate data type: Collision2
        if not isinstance(v, Collision2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Collision2`")
        else:
            match += 1
        # validate data type: TorqueExceeded
        if not isinstance(v, TorqueExceeded):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TorqueExceeded`")
        else:
            match += 1
        # validate data type: InvalidDof
        if not isinstance(v, InvalidDof):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InvalidDof`")
        else:
            match += 1
        # validate data type: NanValue
        if not isinstance(v, NanValue):
            error_messages.append(f"Error! Input type `{type(v)}` is not `NanValue`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in AddTrajectoryErrorData with oneOf schemas: Collision2, InconsitentTrajectorySize, InvalidDof, JointLimitExceeded, NanValue, TcpRequired, TorqueExceeded. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in AddTrajectoryErrorData with oneOf schemas: Collision2, InconsitentTrajectorySize, InvalidDof, JointLimitExceeded, NanValue, TcpRequired, TorqueExceeded. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into TcpRequired
        try:
            instance.actual_instance = TcpRequired.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into InconsitentTrajectorySize
        try:
            instance.actual_instance = InconsitentTrajectorySize.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into JointLimitExceeded
        try:
            instance.actual_instance = JointLimitExceeded.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Collision2
        try:
            instance.actual_instance = Collision2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TorqueExceeded
        try:
            instance.actual_instance = TorqueExceeded.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into InvalidDof
        try:
            instance.actual_instance = InvalidDof.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into NanValue
        try:
            instance.actual_instance = NanValue.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into AddTrajectoryErrorData with oneOf schemas: Collision2, InconsitentTrajectorySize, InvalidDof, JointLimitExceeded, NanValue, TcpRequired, TorqueExceeded. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AddTrajectoryErrorData with oneOf schemas: Collision2, InconsitentTrajectorySize, InvalidDof, JointLimitExceeded, NanValue, TcpRequired, TorqueExceeded. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], Collision2, InconsitentTrajectorySize, InvalidDof, JointLimitExceeded, NanValue, TcpRequired, TorqueExceeded]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


