# coding: utf-8

"""
    Wandelbots Nova API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class DHParameter(BaseModel):
    """
    A single set of DH parameters.
    """ # noqa: E501
    alpha: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Angle about x-axis in [rad].")
    theta: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Angle about z-axis in [rad].")
    a: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Offset along x-axis in [mm].")
    d: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Offset along z-axis in [mm].")
    reverse_rotation_direction: Optional[StrictBool] = Field(default=None, description="True, if rotation direction of joint is reversed.")
    __properties: ClassVar[List[str]] = ["alpha", "theta", "a", "d", "reverse_rotation_direction"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DHParameter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DHParameter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "alpha": obj.get("alpha"),
            "theta": obj.get("theta"),
            "a": obj.get("a"),
            "d": obj.get("d"),
            "reverse_rotation_direction": obj.get("reverse_rotation_direction")
        })
        return _obj


