# coding: utf-8

"""
    Wandelbots Nova API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class TcpVelocityRequest(BaseModel):
    """
    Sets target TCP velocities for jogging a motion group.
    """ # noqa: E501
    message_type: Optional[StrictStr] = Field(default=None, description="Type specifier for server, set automatically. ")
    translation: Annotated[List[Union[StrictFloat, StrictInt]], Field(min_length=3, max_length=3)] = Field(description="A three-dimensional vector [x, y, z] with double precision. ")
    rotation: Annotated[List[Union[StrictFloat, StrictInt]], Field(min_length=3, max_length=3)] = Field(description="A three-dimensional vector [x, y, z] with double precision. ")
    use_tool_coordinate_system: Optional[StrictBool] = Field(default=False, description="If true, TCP velocities are interpreted in the tool coordinate system, specified by the TCP. If false, TCP velocities are interpreted in the world coordinate system. ")
    __properties: ClassVar[List[str]] = ["message_type", "translation", "rotation", "use_tool_coordinate_system"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TcpVelocityRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TcpVelocityRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "message_type": obj.get("message_type"),
            "translation": obj.get("translation"),
            "rotation": obj.get("rotation"),
            "use_tool_coordinate_system": obj.get("use_tool_coordinate_system") if obj.get("use_tool_coordinate_system") is not None else False
        })
        return _obj


