# coding: utf-8

"""
    Wandelbots Nova API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.models.joints import Joints
from typing import Optional, Set
from typing_extensions import Self

class TcpPoseRequest(BaseModel):
    """
    Request to compute the TCP pose for a single joint position sample.
    """ # noqa: E501
    motion_group: StrictStr = Field(description="Unique identifier of the motion-group.")
    joint_position: Joints
    tcp: Optional[StrictStr] = Field(default=None, description="Specifies the TCP at which the pose is calculated via its unique identifier. Optional. If not provided, the currently active TCP is used. ")
    coordinate_system: Optional[StrictStr] = Field(default=None, description="Unique identifier of the base coordinate system of the calculated pose. Optional. If empty, world is used. ")
    __properties: ClassVar[List[str]] = ["motion_group", "joint_position", "tcp", "coordinate_system"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TcpPoseRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of joint_position
        if self.joint_position:
            _dict['joint_position'] = self.joint_position.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TcpPoseRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "motion_group": obj.get("motion_group"),
            "joint_position": Joints.from_dict(obj["joint_position"]) if obj.get("joint_position") is not None else None,
            "tcp": obj.get("tcp"),
            "coordinate_system": obj.get("coordinate_system")
        })
        return _obj


