# coding: utf-8

"""
    Wandelbots Nova API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.models.motion_group_state import MotionGroupState
from wandelbots_api_client.models.tcp_pose import TcpPose
from typing import Optional, Set
from typing_extensions import Self

class MotionGroupStateResponse(BaseModel):
    """
    MotionGroupStateResponse
    """ # noqa: E501
    state: MotionGroupState = Field(description="Current state of the motion group. ")
    tcp_pose: Optional[TcpPose] = Field(default=None, description="Current position of the TCP specified as `tcp` in the request. Attention: This TCP is not necessarily the same the one currently selected on the robot control panel. If you need the information for the currently selected TCP, use the state.tcp_pose in the response. If `tcp` is not specified in the request, this field will be omitted in the response. Position is in [mm]. The position is relative to the response_coordinate_system specified in the request. ")
    __properties: ClassVar[List[str]] = ["state", "tcp_pose"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MotionGroupStateResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict['state'] = self.state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tcp_pose
        if self.tcp_pose:
            _dict['tcp_pose'] = self.tcp_pose.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MotionGroupStateResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "state": MotionGroupState.from_dict(obj["state"]) if obj.get("state") is not None else None,
            "tcp_pose": TcpPose.from_dict(obj["tcp_pose"]) if obj.get("tcp_pose") is not None else None
        })
        return _obj


