# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.initialize_movement_request import InitializeMovementRequest
from wandelbots_api_client.v2.models.pause_movement_request import PauseMovementRequest
from wandelbots_api_client.v2.models.playback_speed_request import PlaybackSpeedRequest
from wandelbots_api_client.v2.models.start_movement_request import StartMovementRequest
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

EXECUTETRAJECTORYREQUEST_ONE_OF_SCHEMAS = ["InitializeMovementRequest", "PauseMovementRequest", "PlaybackSpeedRequest", "StartMovementRequest"]

class ExecuteTrajectoryRequest(BaseModel):
    """
    ExecuteTrajectoryRequest
    """
    # data type: InitializeMovementRequest
    oneof_schema_1_validator: Optional[InitializeMovementRequest] = None
    # data type: StartMovementRequest
    oneof_schema_2_validator: Optional[StartMovementRequest] = None
    # data type: PauseMovementRequest
    oneof_schema_3_validator: Optional[PauseMovementRequest] = None
    # data type: PlaybackSpeedRequest
    oneof_schema_4_validator: Optional[PlaybackSpeedRequest] = None
    actual_instance: Optional[Union[InitializeMovementRequest, PauseMovementRequest, PlaybackSpeedRequest, StartMovementRequest]] = None
    one_of_schemas: Set[str] = { "InitializeMovementRequest", "PauseMovementRequest", "PlaybackSpeedRequest", "StartMovementRequest" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ExecuteTrajectoryRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: InitializeMovementRequest
        if not isinstance(v, InitializeMovementRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InitializeMovementRequest`")
        else:
            match += 1
        # validate data type: StartMovementRequest
        if not isinstance(v, StartMovementRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `StartMovementRequest`")
        else:
            match += 1
        # validate data type: PauseMovementRequest
        if not isinstance(v, PauseMovementRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PauseMovementRequest`")
        else:
            match += 1
        # validate data type: PlaybackSpeedRequest
        if not isinstance(v, PlaybackSpeedRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PlaybackSpeedRequest`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ExecuteTrajectoryRequest with oneOf schemas: InitializeMovementRequest, PauseMovementRequest, PlaybackSpeedRequest, StartMovementRequest. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ExecuteTrajectoryRequest with oneOf schemas: InitializeMovementRequest, PauseMovementRequest, PlaybackSpeedRequest, StartMovementRequest. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into InitializeMovementRequest
        try:
            instance.actual_instance = InitializeMovementRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into StartMovementRequest
        try:
            instance.actual_instance = StartMovementRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PauseMovementRequest
        try:
            instance.actual_instance = PauseMovementRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PlaybackSpeedRequest
        try:
            instance.actual_instance = PlaybackSpeedRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ExecuteTrajectoryRequest with oneOf schemas: InitializeMovementRequest, PauseMovementRequest, PlaybackSpeedRequest, StartMovementRequest. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ExecuteTrajectoryRequest with oneOf schemas: InitializeMovementRequest, PauseMovementRequest, PlaybackSpeedRequest, StartMovementRequest. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], InitializeMovementRequest, PauseMovementRequest, PlaybackSpeedRequest, StartMovementRequest]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


