# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.models.collider import Collider
from wandelbots_api_client.models.collision_motion_group_assembly import CollisionMotionGroupAssembly
from wandelbots_api_client.models.collision_scene import CollisionScene
from typing import Optional, Set
from typing_extensions import Self

class CollisionSceneAssembly(BaseModel):
    """
    Defines the collision scene assembly. Merges all referenced and new scene components into a single scene.  Previously added components with identical identifiers are overwritten within the same group.  There is one group for each of the following components: - Colliders attached to the origin of the scene, - Tool per motion group, and - For each link per motion group.  The scene is assembled by adding components in the following order. 1. stored_scenes 2. scene 3. stored_colliders 4. colliders 5. stored_link_chains and stored_tools (per motion group) 6. link_chains and tools (per motion group) 
    """ # noqa: E501
    stored_scenes: Optional[List[StrictStr]] = Field(default=None, description="Add stored scenes to the scene via their identifiers. The scenes are merged based on their order in the array. The scene at index zero serves as base. Following scenes overwrite components with identical identifiers, see [Collision Scene Assembly](Collision Scene Assembly). ")
    scene: Optional[CollisionScene] = None
    stored_colliders: Optional[List[StrictStr]] = Field(default=None, description="Add stored colliders to the scene via their identifiers. The colliders are added to the the origin of the scene. ")
    colliders: Optional[Dict[str, Collider]] = Field(default=None, description="A collection of identifiable colliders.")
    motion_groups: Optional[Dict[str, CollisionMotionGroupAssembly]] = Field(default=None, description="Maps a Wandelbots NOVA motion group to its assembly configuration in the collision scene. Key must be a motion group identifier.  A collision motion group defines a motion group in the collision scene.  The motion group is attached to the origin of the scene. To relocate the motion group, configure its mounting offset on the physical controller. This ensures that the definition of motion commands and collision scenes use the same coordinate system. The kinematic chain looks like this: - Origin >> Mounting >> Base >> Joint 0 >> Link 0 >> Joint 1 >> […] >> TCP  A `tool` is treated like another link attached to the end (flange) of the kinematic chain. All tool colliders are described in the flange frame. ")
    __properties: ClassVar[List[str]] = ["stored_scenes", "scene", "stored_colliders", "colliders", "motion_groups"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CollisionSceneAssembly from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of scene
        if self.scene:
            _dict['scene'] = self.scene.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in colliders (dict)
        _field_dict = {}
        if self.colliders:
            for _key in self.colliders:
                if self.colliders[_key]:
                    _field_dict[_key] = self.colliders[_key].to_dict()
            _dict['colliders'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in motion_groups (dict)
        _field_dict = {}
        if self.motion_groups:
            for _key in self.motion_groups:
                if self.motion_groups[_key]:
                    _field_dict[_key] = self.motion_groups[_key].to_dict()
            _dict['motion_groups'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CollisionSceneAssembly from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "stored_scenes": obj.get("stored_scenes"),
            "scene": CollisionScene.from_dict(obj["scene"]) if obj.get("scene") is not None else None,
            "stored_colliders": obj.get("stored_colliders"),
            "colliders": dict(
                (_k, Collider.from_dict(_v))
                for _k, _v in obj["colliders"].items()
            )
            if obj.get("colliders") is not None
            else None,
            "motion_groups": dict(
                (_k, CollisionMotionGroupAssembly.from_dict(_v))
                for _k, _v in obj["motion_groups"].items()
            )
            if obj.get("motion_groups") is not None
            else None
        })
        return _obj


