# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from furl import furl
import json
import humps
import re
import warnings
import websockets
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, AsyncGenerator, Callable, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated
from urllib.parse import quote

from pydantic import Field, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from wandelbots_api_client.v2.models.coordinate_system import CoordinateSystem
from wandelbots_api_client.v2.models.list_response import ListResponse
from wandelbots_api_client.v2.models.orientation_type import OrientationType
from wandelbots_api_client.v2.models.pose import Pose

from wandelbots_api_client.v2.api_client import ApiClient, RequestSerialized
from wandelbots_api_client.v2.api_response import ApiResponse
from wandelbots_api_client.v2.rest import RESTResponseType

class CoordinateSystemsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    async def get_coordinate_system(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        coordinate_system: Annotated[StrictStr, Field(description="Unique identifier addressing a coordinate system.")],
        orientation_type: Optional[OrientationType] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CoordinateSystem:
        """Description

        Request a coordinate system specification for a given identifier. Use parameter orientation_type to get the orientation part of the transformation offset of the coordinate system returned in the requested orientation notation. If parameter orientation_type is not set, the orientation part of the transformation offset of the coordinate system is returned in rotation vector notation.  The coordinate systems from the robot controller are loaded when the motion group associated with the coordinate system is activated. With deactivation of the motion group, the associated coordinate systems are removed from NOVA. The unique identifier of the coordinate systems from the robot controllers are suffixed with \"On\" + the unique identifier of the robot controller. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param coordinate_system: Unique identifier addressing a coordinate system. (required)
        :type coordinate_system: str
        :param orientation_type:
        :type orientation_type: OrientationType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_coordinate_system_serialize(
            cell=cell,
            coordinate_system=coordinate_system,
            orientation_type=orientation_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CoordinateSystem",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_coordinate_system_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        coordinate_system: Annotated[StrictStr, Field(description="Unique identifier addressing a coordinate system.")],
        orientation_type: Optional[OrientationType] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CoordinateSystem]:
        """Description

        Request a coordinate system specification for a given identifier. Use parameter orientation_type to get the orientation part of the transformation offset of the coordinate system returned in the requested orientation notation. If parameter orientation_type is not set, the orientation part of the transformation offset of the coordinate system is returned in rotation vector notation.  The coordinate systems from the robot controller are loaded when the motion group associated with the coordinate system is activated. With deactivation of the motion group, the associated coordinate systems are removed from NOVA. The unique identifier of the coordinate systems from the robot controllers are suffixed with \"On\" + the unique identifier of the robot controller. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param coordinate_system: Unique identifier addressing a coordinate system. (required)
        :type coordinate_system: str
        :param orientation_type:
        :type orientation_type: OrientationType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_coordinate_system_serialize(
            cell=cell,
            coordinate_system=coordinate_system,
            orientation_type=orientation_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CoordinateSystem",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_coordinate_system_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        coordinate_system: Annotated[StrictStr, Field(description="Unique identifier addressing a coordinate system.")],
        orientation_type: Optional[OrientationType] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Description

        Request a coordinate system specification for a given identifier. Use parameter orientation_type to get the orientation part of the transformation offset of the coordinate system returned in the requested orientation notation. If parameter orientation_type is not set, the orientation part of the transformation offset of the coordinate system is returned in rotation vector notation.  The coordinate systems from the robot controller are loaded when the motion group associated with the coordinate system is activated. With deactivation of the motion group, the associated coordinate systems are removed from NOVA. The unique identifier of the coordinate systems from the robot controllers are suffixed with \"On\" + the unique identifier of the robot controller. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param coordinate_system: Unique identifier addressing a coordinate system. (required)
        :type coordinate_system: str
        :param orientation_type:
        :type orientation_type: OrientationType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_coordinate_system_serialize(
            cell=cell,
            coordinate_system=coordinate_system,
            orientation_type=orientation_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CoordinateSystem",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_coordinate_system_serialize(
        self,
        cell,
        coordinate_system,
        orientation_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if coordinate_system is not None:
            _path_params['coordinate-system'] = coordinate_system
        # process the query parameters
        if orientation_type is not None:
            
            _query_params.append(('orientation_type', orientation_type.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/coordinate-systems/{coordinate-system}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def list_coordinate_systems(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        orientation_type: Optional[OrientationType] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListResponse:
        """List

        Lists all specifications of coordinate systems from robot controllers. Use parameter orientation_type to get the orientation part of the transformation offset of the coordinate system returned in the requested orientation notation. If parameter orientation_type is not set, the orientation part of the transformation offset of the coordinate system is returned in rotation vector notation.  The coordinate systems from the robot controller are loaded when the motion group associated with the coordinate system is activated. With deactivation of the motion group, the associated coordinate systems are removed from NOVA. The unique identifier of the coordinate systems from the robot controllers are suffixed with \"On\" + the unique identifier of the robot controller. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param orientation_type:
        :type orientation_type: OrientationType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_coordinate_systems_serialize(
            cell=cell,
            orientation_type=orientation_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_coordinate_systems_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        orientation_type: Optional[OrientationType] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListResponse]:
        """List

        Lists all specifications of coordinate systems from robot controllers. Use parameter orientation_type to get the orientation part of the transformation offset of the coordinate system returned in the requested orientation notation. If parameter orientation_type is not set, the orientation part of the transformation offset of the coordinate system is returned in rotation vector notation.  The coordinate systems from the robot controller are loaded when the motion group associated with the coordinate system is activated. With deactivation of the motion group, the associated coordinate systems are removed from NOVA. The unique identifier of the coordinate systems from the robot controllers are suffixed with \"On\" + the unique identifier of the robot controller. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param orientation_type:
        :type orientation_type: OrientationType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_coordinate_systems_serialize(
            cell=cell,
            orientation_type=orientation_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_coordinate_systems_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        orientation_type: Optional[OrientationType] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List

        Lists all specifications of coordinate systems from robot controllers. Use parameter orientation_type to get the orientation part of the transformation offset of the coordinate system returned in the requested orientation notation. If parameter orientation_type is not set, the orientation part of the transformation offset of the coordinate system is returned in rotation vector notation.  The coordinate systems from the robot controller are loaded when the motion group associated with the coordinate system is activated. With deactivation of the motion group, the associated coordinate systems are removed from NOVA. The unique identifier of the coordinate systems from the robot controllers are suffixed with \"On\" + the unique identifier of the robot controller. 

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param orientation_type:
        :type orientation_type: OrientationType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_coordinate_systems_serialize(
            cell=cell,
            orientation_type=orientation_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_coordinate_systems_serialize(
        self,
        cell,
        orientation_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        if orientation_type is not None:
            
            _query_params.append(('orientation_type', orientation_type.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/coordinate-systems',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def transform_in_coordinate_system(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        coordinate_system: Annotated[StrictStr, Field(description="Unique identifier addressing a coordinate system.")],
        pose: Pose,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Pose:
        """Transform

        Transform a pose to another base.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param coordinate_system: Unique identifier addressing a coordinate system. (required)
        :type coordinate_system: str
        :param pose: (required)
        :type pose: Pose
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._transform_in_coordinate_system_serialize(
            cell=cell,
            coordinate_system=coordinate_system,
            pose=pose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Pose",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def transform_in_coordinate_system_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        coordinate_system: Annotated[StrictStr, Field(description="Unique identifier addressing a coordinate system.")],
        pose: Pose,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Pose]:
        """Transform

        Transform a pose to another base.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param coordinate_system: Unique identifier addressing a coordinate system. (required)
        :type coordinate_system: str
        :param pose: (required)
        :type pose: Pose
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._transform_in_coordinate_system_serialize(
            cell=cell,
            coordinate_system=coordinate_system,
            pose=pose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Pose",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def transform_in_coordinate_system_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. ")],
        coordinate_system: Annotated[StrictStr, Field(description="Unique identifier addressing a coordinate system.")],
        pose: Pose,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Transform

        Transform a pose to another base.

        :param cell: Unique identifier addressing a cell in all API calls.  (required)
        :type cell: str
        :param coordinate_system: Unique identifier addressing a coordinate system. (required)
        :type coordinate_system: str
        :param pose: (required)
        :type pose: Pose
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._transform_in_coordinate_system_serialize(
            cell=cell,
            coordinate_system=coordinate_system,
            pose=pose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Pose",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _transform_in_coordinate_system_serialize(
        self,
        cell,
        coordinate_system,
        pose,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if coordinate_system is not None:
            _path_params['coordinate-system'] = coordinate_system
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if pose is not None:
            _body_params = pose


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/cells/{cell}/coordinate-systems/{coordinate-system}/transform',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


