# coding: utf-8

"""
    Wandelbots Nova API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class VersionNumber(BaseModel):
    """
    A generic representation of a version number.
    """ # noqa: E501
    major_version: StrictInt
    minor_version: Optional[StrictInt] = None
    build_version: Optional[StrictInt] = None
    bugfix_version: Optional[StrictInt] = None
    minor_version_wildcard: Optional[StrictBool] = Field(default=None, description="If minor version is a wildcard set to true.")
    build_version_wildcard: Optional[StrictBool] = Field(default=None, description="If build version is a wildcard set to true.")
    bugfix_version_wildcard: Optional[StrictBool] = Field(default=None, description="If bugfix version is a wildcard set to true.")
    string_version: Optional[StrictStr] = Field(default=None, description="A string representation of the version e.g. 1.1.x.x.")
    __properties: ClassVar[List[str]] = ["major_version", "minor_version", "build_version", "bugfix_version", "minor_version_wildcard", "build_version_wildcard", "bugfix_version_wildcard", "string_version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VersionNumber from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VersionNumber from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "major_version": obj.get("major_version"),
            "minor_version": obj.get("minor_version"),
            "build_version": obj.get("build_version"),
            "bugfix_version": obj.get("bugfix_version"),
            "minor_version_wildcard": obj.get("minor_version_wildcard"),
            "build_version_wildcard": obj.get("build_version_wildcard"),
            "bugfix_version_wildcard": obj.get("bugfix_version_wildcard"),
            "string_version": obj.get("string_version")
        })
        return _obj


