# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class InitializeJoggingRequest(BaseModel):
    """
    Send this message to start jogging a motion group.
    """ # noqa: E501
    message_type: Optional[StrictStr] = Field(default=None, description="Type specifier for server, set automatically. ")
    motion_group: StrictStr = Field(description="Identifier of the motion group.")
    tcp: Optional[StrictStr] = Field(default=None, description="Identifier of the tool. Required for robots. Not required for external axes.")
    response_rate: Optional[StrictInt] = Field(default=200, description="Update rate for the response message in milliseconds (ms).  Recommendation: As Wandelbots NOVA updates states in the controller's step rate, use either the controller's step rate or a multiple of it.                 Wandelbots NOVA will not interpolate the state but round it to the nearest step rate below the configured response rate. Use [getOptimizerConfiguration](getOptimizerConfiguration) to get the controller's step rate.  Minimal response rate is the step rate of the controller. ")
    response_coordinate_system: Optional[StrictStr] = Field(default=None, description="Unique identifier addressing a coordinate system to which the responses are transformed. If not set, world coordinate system is used. ")
    pause_on_io: Optional[StrictStr] = Field(default=None, description="Defines an input/output that is listened to during the movement. Execution pauses if the defined comparator evaluates to `true`. ")
    __properties: ClassVar[List[str]] = ["message_type", "motion_group", "tcp", "response_rate", "response_coordinate_system", "pause_on_io"]

    @field_validator('message_type')
    def message_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['InitializeJoggingRequest']):
            raise ValueError("must be one of enum values ('InitializeJoggingRequest')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InitializeJoggingRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InitializeJoggingRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "message_type": obj.get("message_type"),
            "motion_group": obj.get("motion_group"),
            "tcp": obj.get("tcp"),
            "response_rate": obj.get("response_rate") if obj.get("response_rate") is not None else 200,
            "response_coordinate_system": obj.get("response_coordinate_system"),
            "pause_on_io": obj.get("pause_on_io")
        })
        return _obj


