# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PyripheryPyraeControllerControllerConfiguration(BaseModel):
    """
    Configuration of a Robot Controller.  This will configure the robot controller such that it is controllable through Wandelscript.  This is for advanced users only: it should not be necessary to change this configuration in most use cases.
    """ # noqa: E501
    type: Optional[Any] = None
    identifier: Optional[StrictStr] = 'controller'
    host: Optional[StrictStr] = 'virtual-ur10e'
    controller_model_name: Optional[StrictStr] = 'UniversalRobots::Controller'
    rae_host: Optional[StrictStr] = 'rae'
    rae_port: Optional[StrictInt] = 50051
    __properties: ClassVar[List[str]] = ["type", "identifier", "host", "controller_model_name", "rae_host", "rae_port"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PyripheryPyraeControllerControllerConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PyripheryPyraeControllerControllerConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "identifier": obj.get("identifier") if obj.get("identifier") is not None else 'controller',
            "host": obj.get("host") if obj.get("host") is not None else 'virtual-ur10e',
            "controller_model_name": obj.get("controller_model_name") if obj.get("controller_model_name") is not None else 'UniversalRobots::Controller',
            "rae_host": obj.get("rae_host") if obj.get("rae_host") is not None else 'rae',
            "rae_port": obj.get("rae_port") if obj.get("rae_port") is not None else 50051
        })
        return _obj


