# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.motion_group_physical import MotionGroupPhysical
from wandelbots_api_client.v2.models.version_number import VersionNumber
from typing import Optional, Set
from typing_extensions import Self

class Controller(BaseModel):
    """
    The data type to describe a robot controller.
    """ # noqa: E501
    controller: StrictStr = Field(description="The unique identifier to address the robot controller in the cell. ")
    model_name: StrictStr = Field(description="The unique identifier to address a robot controller model when configuring the robot controller. Used for evaluation of the robot controller model and to ensure communication with the expected robot controller type. ")
    host: StrictStr = Field(description="Resolvable host name or IP address that connects to the robot controller. ")
    allow_software_install_on_controller: StrictBool = Field(description="True if the user has actively confirmed that it is allowed to install required communication software onto the robot controller.  NOTE: Installing third party software on a robot controller can result in liability issues in regard to the actual certified state of the robot system. Please contact your company's legal responsible before installing third party software. ")
    motion_groups: List[MotionGroupPhysical] = Field(description="The list of physical connected motion groups as detected by the controller. ")
    vendor_software_version: Optional[VersionNumber] = None
    has_error: StrictBool = Field(description="Set to true if there was an error while inspecting this instance, e.g. The robot controller is not reachable due to missing network connection or turned off.  The instance remains configured but can't provide information on the robot controller. ")
    error_details: Optional[StrictStr] = Field(default=None, description="If has_error is true, error_details provides detailed background information about the error. ")
    __properties: ClassVar[List[str]] = ["controller", "model_name", "host", "allow_software_install_on_controller", "motion_groups", "vendor_software_version", "has_error", "error_details"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Controller from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in motion_groups (list)
        _items = []
        if self.motion_groups:
            for _item in self.motion_groups:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['motion_groups'] = _items
        # override the default output from pydantic by calling `to_dict()` of vendor_software_version
        if self.vendor_software_version:
            _dict['vendor_software_version'] = self.vendor_software_version.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Controller from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "controller": obj.get("controller"),
            "model_name": obj.get("model_name"),
            "host": obj.get("host"),
            "allow_software_install_on_controller": obj.get("allow_software_install_on_controller"),
            "motion_groups": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                MotionGroupPhysical.from_dict(_item) if hasattr(MotionGroupPhysical, 'from_dict') else _item
                # <<< End modification
                for _item in obj["motion_groups"]
            ] if obj.get("motion_groups") is not None else None,
            "vendor_software_version": VersionNumber.from_dict(obj["vendor_software_version"]) if obj.get("vendor_software_version") is not None else None,
            "has_error": obj.get("has_error"),
            "error_details": obj.get("error_details")
        })
        return _obj


