# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.io_boolean_value2 import IOBooleanValue2
from wandelbots_api_client.v2.models.io_float_value2 import IOFloatValue2
from wandelbots_api_client.v2.models.io_integer_value2 import IOIntegerValue2
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

SETIOVALUESREQUESTINNER_ONE_OF_SCHEMAS = ["IOBooleanValue2", "IOFloatValue2", "IOIntegerValue2"]

class SetIOValuesRequestInner(BaseModel):
    """
    SetIOValuesRequestInner
    """
    # data type: IOBooleanValue2
    oneof_schema_1_validator: Optional[IOBooleanValue2] = None
    # data type: IOIntegerValue2
    oneof_schema_2_validator: Optional[IOIntegerValue2] = None
    # data type: IOFloatValue2
    oneof_schema_3_validator: Optional[IOFloatValue2] = None
    actual_instance: Optional[Union[IOBooleanValue2, IOFloatValue2, IOIntegerValue2]] = None
    one_of_schemas: Set[str] = { "IOBooleanValue2", "IOFloatValue2", "IOIntegerValue2" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = SetIOValuesRequestInner.model_construct()
        error_messages = []
        match = 0
        # validate data type: IOBooleanValue2
        if not isinstance(v, IOBooleanValue2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `IOBooleanValue2`")
        else:
            match += 1
        # validate data type: IOIntegerValue2
        if not isinstance(v, IOIntegerValue2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `IOIntegerValue2`")
        else:
            match += 1
        # validate data type: IOFloatValue2
        if not isinstance(v, IOFloatValue2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `IOFloatValue2`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in SetIOValuesRequestInner with oneOf schemas: IOBooleanValue2, IOFloatValue2, IOIntegerValue2. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in SetIOValuesRequestInner with oneOf schemas: IOBooleanValue2, IOFloatValue2, IOIntegerValue2. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into IOBooleanValue2
        try:
            instance.actual_instance = IOBooleanValue2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into IOIntegerValue2
        try:
            instance.actual_instance = IOIntegerValue2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into IOFloatValue2
        try:
            instance.actual_instance = IOFloatValue2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into SetIOValuesRequestInner with oneOf schemas: IOBooleanValue2, IOFloatValue2, IOIntegerValue2. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into SetIOValuesRequestInner with oneOf schemas: IOBooleanValue2, IOFloatValue2, IOIntegerValue2. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], IOBooleanValue2, IOFloatValue2, IOIntegerValue2]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


