# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.models.command import Command
from wandelbots_api_client.models.joints import Joints
from typing import Optional, Set
from typing_extensions import Self

class PlanRequest(BaseModel):
    """
    PlanRequest
    """ # noqa: E501
    motion_group: StrictStr = Field(description="Identifier of the motion group.")
    start_joint_position: Joints = Field(description="-| To define a motion the start joints have to be indicated. Cartesian movements will be in the same kinematic configuration as the start joint position until the first joint point to point motion. Motions can only be executed, if the start joint position is the current joint position of the motion group. To retrieve the current joint position use the endpoint [getCurrentMotionGroupState](getCurrentMotionGroupState). To move the robot to the start joint position, use the endpoint [streamMoveToTrajectoryViaJointP2P](streamMoveToTrajectoryViaJointP2P).")
    commands: List[Command] = Field(description="List of motion commands. A command consists of a motion command (line, circle, joint_ptp, cartesian_ptp, cubic_spline) and corresponding settings (blending, limits override).")
    tcp: Optional[StrictStr] = Field(default=None, description="Tool identifier. If not set the current tool is used.")
    payload: Optional[StrictStr] = Field(default=None, description="Payload identifier. If unset the currently set payload is used.")
    __properties: ClassVar[List[str]] = ["motion_group", "start_joint_position", "commands", "tcp", "payload"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlanRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of start_joint_position
        if self.start_joint_position:
            _dict['start_joint_position'] = self.start_joint_position.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in commands (list)
        _items = []
        if self.commands:
            for _item in self.commands:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['commands'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlanRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "motion_group": obj.get("motion_group"),
            "start_joint_position": Joints.from_dict(obj["start_joint_position"]) if obj.get("start_joint_position") is not None else None,
            "commands": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                Command.from_dict(_item) if hasattr(Command, 'from_dict') else _item
                # <<< End modification
                for _item in obj["commands"]
            ] if obj.get("commands") is not None else None,
            "tcp": obj.get("tcp"),
            "payload": obj.get("payload")
        })
        return _obj


