# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.dh_parameter import DHParameter
from wandelbots_api_client.v2.models.motion_group_model import MotionGroupModel
from wandelbots_api_client.v2.models.payload import Payload
from wandelbots_api_client.v2.models.planner_pose import PlannerPose
from wandelbots_api_client.v2.models.safety_configuration import SafetyConfiguration
from typing import Optional, Set
from typing_extensions import Self

class OptimizerSetup(BaseModel):
    """
    The configuration of a motion-group used for motion planning.
    """ # noqa: E501
    motion_group_type: MotionGroupModel
    mounting: PlannerPose = Field(description="The offset from the world frame to the motion group base.")
    tcp: PlannerPose = Field(description="The offset from the motion group flange to the tool center point.")
    safety_setup: SafetyConfiguration = Field(description="The limits, safety zones and collision models of the motion group and tool.")
    payload: Optional[Payload] = Field(default=None, description="The dynamic parameters (mass, inertias, center of gravity) of the payload located at the tool center point.")
    cycle_time: Optional[StrictInt] = Field(default=None, description="[ms] cycle time of the motion group controller. A trajectory for this motion group should be computed to this resolution.")
    dh_parameters: Optional[List[DHParameter]] = Field(default=None, description="The DH parameters describing the motion group geometry, starting from base.")
    __properties: ClassVar[List[str]] = ["motion_group_type", "mounting", "tcp", "safety_setup", "payload", "cycle_time", "dh_parameters"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OptimizerSetup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of mounting
        if self.mounting:
            _dict['mounting'] = self.mounting.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tcp
        if self.tcp:
            _dict['tcp'] = self.tcp.to_dict()
        # override the default output from pydantic by calling `to_dict()` of safety_setup
        if self.safety_setup:
            _dict['safety_setup'] = self.safety_setup.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payload
        if self.payload:
            _dict['payload'] = self.payload.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in dh_parameters (list)
        _items = []
        if self.dh_parameters:
            for _item in self.dh_parameters:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['dh_parameters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OptimizerSetup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "motion_group_type": obj.get("motion_group_type"),
            "mounting": PlannerPose.from_dict(obj["mounting"]) if obj.get("mounting") is not None else None,
            "tcp": PlannerPose.from_dict(obj["tcp"]) if obj.get("tcp") is not None else None,
            "safety_setup": SafetyConfiguration.from_dict(obj["safety_setup"]) if obj.get("safety_setup") is not None else None,
            "payload": Payload.from_dict(obj["payload"]) if obj.get("payload") is not None else None,
            "cycle_time": obj.get("cycle_time"),
            "dh_parameters": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                DHParameter.from_dict(_item) if hasattr(DHParameter, 'from_dict') else _item
                # <<< End modification
                for _item in obj["dh_parameters"]
            ] if obj.get("dh_parameters") is not None else None
        })
        return _obj


