# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.run_args_value import RunArgsValue
from typing import Optional, Set
from typing_extensions import Self

class ProgramRequest(BaseModel):
    """
    ProgramRequest
    """ # noqa: E501
    program: Optional[StrictStr] = '''# Read the current pose of the robot.
#
# Note: Please replace <controller_id> with the controller name you've
#   selected and <motion_group_id> with the motion group ID
#
# Example:
#   - "0@abb" = get_controller("abb")[0]
#   - "1@fanuc" = get_controller("fanuc")[1]
#
robot = get_controller("controller")[0]
tcp("Flange")
home = read(robot, "pose")
sync

# Set the velocity of the robot to 200 mm/s
velocity(200)

for i = 0..3:
    move via ptp() to home
    # Move to a pose concatenating the home pose
    move via line() to (50, 20, 30, 0, 0, 0) :: home
    move via line() to (100, 20, 30, 0, 0, 0) :: home
    move via line() to (50, 20, 30, 0, 0, 0) :: home
    move via ptp() to home
'''
    default_robot: Optional[StrictStr] = None
    default_tcp: Optional[StrictStr] = None
    run_args: Optional[Dict[str, Optional[RunArgsValue]]] = Field(default=None, description="Initial arguments that are available within the program")
    __properties: ClassVar[List[str]] = ["program", "default_robot", "default_tcp", "run_args"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgramRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in run_args (dict)
        _field_dict = {}
        if self.run_args:
            for _key in self.run_args:
                if self.run_args[_key]:
                    _field_dict[_key] = self.run_args[_key].to_dict()
            _dict['run_args'] = _field_dict
        # set to None if default_robot (nullable) is None
        # and model_fields_set contains the field
        if self.default_robot is None and "default_robot" in self.model_fields_set:
            _dict['default_robot'] = None

        # set to None if default_tcp (nullable) is None
        # and model_fields_set contains the field
        if self.default_tcp is None and "default_tcp" in self.model_fields_set:
            _dict['default_tcp'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgramRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "program": obj.get("program") if obj.get("program") is not None else '''# Read the current pose of the robot.
#
# Note: Please replace <controller_id> with the controller name you've
#   selected and <motion_group_id> with the motion group ID
#
# Example:
#   - "0@abb" = get_controller("abb")[0]
#   - "1@fanuc" = get_controller("fanuc")[1]
#
robot = get_controller("controller")[0]
tcp("Flange")
home = read(robot, "pose")
sync

# Set the velocity of the robot to 200 mm/s
velocity(200)

for i = 0..3:
    move via ptp() to home
    # Move to a pose concatenating the home pose
    move via line() to (50, 20, 30, 0, 0, 0) :: home
    move via line() to (100, 20, 30, 0, 0, 0) :: home
    move via line() to (50, 20, 30, 0, 0, 0) :: home
    move via ptp() to home
''',
            "default_robot": obj.get("default_robot"),
            "default_tcp": obj.get("default_tcp"),
            "run_args": dict(
                (_k, RunArgsValue.from_dict(_v))
                for _k, _v in obj["run_args"].items()
            )
            if obj.get("run_args") is not None
            else None
        })
        return _obj


