# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from wandelbots_api_client.v2.models.program_run_result import ProgramRunResult
from wandelbots_api_client.v2.models.program_run_state import ProgramRunState
from wandelbots_api_client.v2.models.store_value import StoreValue
from typing import Optional, Set
from typing_extensions import Self

class ProgramRun(BaseModel):
    """
    Holds the state of a program run.  Args:     id: The unique id of the program run     state: The state of the program run     logs: The logs of the program run     stdout: The stdout of the program run     store: The store of the program run     error: The error message of the program run, if any     traceback: The traceback of the program run, if any     start_time: The start time of the program run     end_time: The end time of the program run     execution_results: The robot execution results of the program run
    """ # noqa: E501
    id: StrictStr = Field(description="Unique id of the program run")
    state: ProgramRunState = Field(description="State of the program run")
    logs: Optional[StrictStr] = None
    stdout: Optional[StrictStr] = None
    store: Optional[Dict[str, StoreValue]] = Field(default=None, description="Stores runtime variables of the run")
    error: Optional[StrictStr] = None
    traceback: Optional[StrictStr] = None
    start_time: Optional[Union[StrictFloat, StrictInt]] = None
    end_time: Optional[Union[StrictFloat, StrictInt]] = None
    execution_results: Optional[List[ProgramRunResult]] = Field(default=None, description="Execution results of the program run")
    __properties: ClassVar[List[str]] = ["id", "state", "logs", "stdout", "store", "error", "traceback", "start_time", "end_time", "execution_results"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgramRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in store (dict)
        _field_dict = {}
        if self.store:
            for _key in self.store:
                if self.store[_key]:
                    _field_dict[_key] = self.store[_key].to_dict()
            _dict['store'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in execution_results (list)
        _items = []
        if self.execution_results:
            for _item in self.execution_results:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['execution_results'] = _items
        # set to None if logs (nullable) is None
        # and model_fields_set contains the field
        if self.logs is None and "logs" in self.model_fields_set:
            _dict['logs'] = None

        # set to None if stdout (nullable) is None
        # and model_fields_set contains the field
        if self.stdout is None and "stdout" in self.model_fields_set:
            _dict['stdout'] = None

        # set to None if error (nullable) is None
        # and model_fields_set contains the field
        if self.error is None and "error" in self.model_fields_set:
            _dict['error'] = None

        # set to None if traceback (nullable) is None
        # and model_fields_set contains the field
        if self.traceback is None and "traceback" in self.model_fields_set:
            _dict['traceback'] = None

        # set to None if start_time (nullable) is None
        # and model_fields_set contains the field
        if self.start_time is None and "start_time" in self.model_fields_set:
            _dict['start_time'] = None

        # set to None if end_time (nullable) is None
        # and model_fields_set contains the field
        if self.end_time is None and "end_time" in self.model_fields_set:
            _dict['end_time'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgramRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "state": obj.get("state"),
            "logs": obj.get("logs"),
            "stdout": obj.get("stdout"),
            "store": dict(
                (_k, StoreValue.from_dict(_v))
                for _k, _v in obj["store"].items()
            )
            if obj.get("store") is not None
            else None,
            "error": obj.get("error"),
            "traceback": obj.get("traceback"),
            "start_time": obj.get("start_time"),
            "end_time": obj.get("end_time"),
            "execution_results": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                ProgramRunResult.from_dict(_item) if hasattr(ProgramRunResult, 'from_dict') else _item
                # <<< End modification
                for _item in obj["execution_results"]
            ] if obj.get("execution_results") is not None else None
        })
        return _obj


