# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from furl import furl
import json
import humps
import re
import warnings
import websockets
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, AsyncGenerator, Callable, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated
from urllib.parse import quote

from pydantic import Field, StrictStr
from typing_extensions import Annotated
from wandelbots_api_client.v2.models.execute_jogging_request import ExecuteJoggingRequest
from wandelbots_api_client.v2.models.execute_jogging_response import ExecuteJoggingResponse

from wandelbots_api_client.v2.api_client import ApiClient, RequestSerialized
from wandelbots_api_client.v2.api_response import ApiResponse
from wandelbots_api_client.v2.rest import RESTResponseType

class JoggingApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    async def execute_jogging(self, cell: Annotated[StrictStr, Field(description="Unique identifier addressing a cell in all API calls. ")], client_request_generator: Callable[[AsyncGenerator[ExecuteJoggingResponse, None]], AsyncGenerator[ExecuteJoggingRequest, None]]) -> None:  # noqa: E501
        """Execute Jogging  # noqa: E501

        <!-- theme: danger -->  > Websocket endpoint  Provides execution control over a dynamically adaptable jogging motion for a motion group.  Jogging describes controlling a motion group by sending real-time commands to move either its joints or the TCP (Tool Center Point). The commands contain target velocities that may change at any time during execution, so the resulting motion cannot be computed upfront.  ### Preconditions  The motion group is not moved by any other endpoint.  ### Requests  #### 1. Send InitializeJoggingRequest to configure the jogging.  Sets robot controller mode to control mode. Sets rate and coordinate system for the jogging response.  #### 2. Send JointVelocityRequest or TcpVelocityRequest to start the jogging motion.  #### 3. Change or stop the jogging motion  - Change the jogging direction and/or velocity during the jogging motion with JointVelocityRequest or TcpVelocityRequest. - To stop the jogging motion, send zero velocities via either request.  ### Responses  - InitializeJoggingResponse is sent to signal the success or failure of the InitializeJoggingRequest. - Jogging responses are streamed continuously after an InitializeJoggingRequest is processed.   Jogging responses contain the robot controller state and the state of the jogging control. - JoggingErrorResponse with error details is sent in case of an unexpected error, e.g., controller disconnects during jogging.  ### Tips and Tricks  - In the JoggingResponse, verify that the robot control is in the desired state, e.g. standstill, with JoggingState. - Ensure that the websocket connection remains open until the jogging motion is stopped to avoid unexpected stops.   # noqa: E501
        :param client_request_generator: An AsyncGenerator that yields request of type ExecuteJoggingRequest and takes an AsyncGenerator of ExecuteJoggingResponse as an input argument (required)
        :info All responses from the server will be yielded to client_request_generator through the (AsyncGenerator[ExecuteJoggingResponse, None])
        :type AsyncGenerator[ExecuteJoggingRequest, None]
        """
        def format_path_parameters(path):
            # Find all substrings that are enclosed in brackets
            bracket_contents = re.findall(r'\{(.*?)\}', path)

            # For each found substring, alter it to match the python variable name
            for content in bracket_contents:
                content = "{" + content + "}"
                modified_content = humps.dekebabize(content)
                path = path.replace(content, modified_content)

            return path

        async def iterate_responses(ws) -> AsyncGenerator[ExecuteJoggingResponse, None]:
            async for response in ws:
                if "Cancelled on the server side" in response:
                    break
                response_data = json.loads(response)
                if "result" not in response_data:
                    raise Exception(response_data)
                yield ExecuteJoggingResponse.from_dict(response_data["result"])

        path = format_path_parameters("/cells/{cell}/execution/jogging")
        path = path.format(cell=cell,)

        headers = websockets.Headers()
        tmp_host = self.api_client.configuration.host
        if self.api_client.configuration.host.startswith("https://"):
            # Basic Auth
            if self.api_client.configuration.username:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{self.api_client.configuration.username}:{self.api_client.configuration.password}@{tmp_host}"

            # OAuth2
            elif self.api_client.configuration.access_token:
                tmp_host = self.api_client.configuration.host.replace("https://", "")
                tmp_host = f"wss://{tmp_host}"
                headers = websockets.Headers([
                    ("Authorization", f"Bearer {self.api_client.configuration.access_token}")
                ])
        else:
            tmp_host = tmp_host.replace("http://", "ws://")

        full_url = furl(tmp_host + path)

        async with websockets.connect(full_url.url, open_timeout=10, additional_headers=headers) as websocket:
            async for request in client_request_generator(iterate_responses(websocket)):
                await websocket.send(request.to_json())

