# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from wandelbots_api_client.v2.models.robot_state import RobotState
from typing import Optional, Set
from typing_extensions import Self

class ProgramRunResult(BaseModel):
    """
    The ProgramRunResult object contains the execution results of a robot.  Arguments:     motion_group_id: The unique id of the motion group     motion_duration: The total execution duration of the motion group     paths: The paths of the motion group as list of Path objects
    """ # noqa: E501
    motion_group_id: StrictStr = Field(description="Unique id of the motion group that was executed")
    motion_duration: Union[StrictFloat, StrictInt] = Field(description="Total execution duration of the motion group")
    paths: List[List[RobotState]] = Field(description="Paths of the motion group as list of Path objects")
    __properties: ClassVar[List[str]] = ["motion_group_id", "motion_duration", "paths"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgramRunResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in paths (list of list)
        _items = []
        if self.paths:
            for _item in self.paths:
                if _item:
                    _items.append(
                         [_inner_item.to_dict() for _inner_item in _item if _inner_item is not None]
                    )
            _dict['paths'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgramRunResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "motion_group_id": obj.get("motion_group_id"),
            "motion_duration": obj.get("motion_duration"),
            "paths": [
                    [RobotState.from_dict(_inner_item) for _inner_item in _item]
                    for _item in obj["paths"]
                ] if obj.get("paths") is not None else None
        })
        return _obj


