# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.models.motion_group_state import MotionGroupState
from typing import Optional, Set
from typing_extensions import Self

class RobotControllerState(BaseModel):
    """
    Returns the whole current state of robot controller.
    """ # noqa: E501
    controller: StrictStr = Field(description="Identifier of the configured robot controller.")
    operation_mode: StrictStr = Field(description="Current operation mode of the configured robot controller. Operation modes in which the attached motion groups can be moved are: - OPERATION_MODE_MANUAL (if enabling switch is pressed) - OPERATION_MODE_MANUAL_T1 (if enabling switch is pressed) - OPERATION_MODE_MANUAL_T2 (if enabling switch is pressed) - OPERATION_MODE_AUTO (without needing to press enabling switch) All other modes are considered as non-operational. ")
    safety_state: StrictStr = Field(description="Current safety state of the configured robot controller. Operation modes in which the attached motion groups can be moved are: - SAFETY_STATE_NORMAL - SAFETY_STATE_REDUCED All other modes are considered as non-operational. ")
    timestamp: datetime = Field(description="Timestamp indicating when the represented information was received from the robot controller.")
    velocity_override: Optional[StrictInt] = Field(default=None, description="If made available by the robot controller, returns the current velocity override in [percentage] for movements adjusted on robot control panel. Valid value range: 1 - 100. ")
    motion_groups: List[MotionGroupState] = Field(description="State of indicated motion groups. In case of state request via controller all configured motion groups are returned. In case of executing a motion only the affected motion groups are returned.")
    sequence_number: StrictStr = Field(description="Sequence number of the controller state. It starts with 0 upon establishing the connection with a physical controller. The sequence number is reset when the connection to the physical controller is closed and re-established. It is of type string to represent uint64 values, which is not supported by OpenAPI. ")
    __properties: ClassVar[List[str]] = ["controller", "operation_mode", "safety_state", "timestamp", "velocity_override", "motion_groups", "sequence_number"]

    @field_validator('operation_mode')
    def operation_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['OPERATION_MODE_UNKNOWN', 'OPERATION_MODE_NO_CONTROLLER', 'OPERATION_MODE_DISCONNECTED', 'OPERATION_MODE_POWER_ON', 'OPERATION_MODE_PENDING', 'OPERATION_MODE_MANUAL', 'OPERATION_MODE_MANUAL_T1', 'OPERATION_MODE_MANUAL_T2', 'OPERATION_MODE_AUTO', 'OPERATION_MODE_RECOVERY']):
            raise ValueError("must be one of enum values ('OPERATION_MODE_UNKNOWN', 'OPERATION_MODE_NO_CONTROLLER', 'OPERATION_MODE_DISCONNECTED', 'OPERATION_MODE_POWER_ON', 'OPERATION_MODE_PENDING', 'OPERATION_MODE_MANUAL', 'OPERATION_MODE_MANUAL_T1', 'OPERATION_MODE_MANUAL_T2', 'OPERATION_MODE_AUTO', 'OPERATION_MODE_RECOVERY')")
        return value

    @field_validator('safety_state')
    def safety_state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['SAFETY_STATE_UNKNOWN', 'SAFETY_STATE_FAULT', 'SAFETY_STATE_NORMAL', 'SAFETY_STATE_MASTERING', 'SAFETY_STATE_CONFIRM_SAFETY', 'SAFETY_STATE_OPERATOR_SAFETY', 'SAFETY_STATE_PROTECTIVE_STOP', 'SAFETY_STATE_REDUCED', 'SAFETY_STATE_STOP', 'SAFETY_STATE_STOP_0', 'SAFETY_STATE_STOP_1', 'SAFETY_STATE_STOP_2', 'SAFETY_STATE_RECOVERY', 'SAFETY_STATE_DEVICE_EMERGENCY_STOP', 'SAFETY_STATE_ROBOT_EMERGENCY_STOP', 'SAFETY_STATE_VIOLATION']):
            raise ValueError("must be one of enum values ('SAFETY_STATE_UNKNOWN', 'SAFETY_STATE_FAULT', 'SAFETY_STATE_NORMAL', 'SAFETY_STATE_MASTERING', 'SAFETY_STATE_CONFIRM_SAFETY', 'SAFETY_STATE_OPERATOR_SAFETY', 'SAFETY_STATE_PROTECTIVE_STOP', 'SAFETY_STATE_REDUCED', 'SAFETY_STATE_STOP', 'SAFETY_STATE_STOP_0', 'SAFETY_STATE_STOP_1', 'SAFETY_STATE_STOP_2', 'SAFETY_STATE_RECOVERY', 'SAFETY_STATE_DEVICE_EMERGENCY_STOP', 'SAFETY_STATE_ROBOT_EMERGENCY_STOP', 'SAFETY_STATE_VIOLATION')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RobotControllerState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in motion_groups (list)
        _items = []
        if self.motion_groups:
            for _item in self.motion_groups:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['motion_groups'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RobotControllerState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "controller": obj.get("controller") if obj.get("controller") is not None else 'controller',
            "operation_mode": obj.get("operation_mode"),
            "safety_state": obj.get("safety_state"),
            "timestamp": obj.get("timestamp"),
            "velocity_override": obj.get("velocity_override"),
            "motion_groups": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                MotionGroupState.from_dict(_item) if hasattr(MotionGroupState, 'from_dict') else _item
                # <<< End modification
                for _item in obj["motion_groups"]
            ] if obj.get("motion_groups") is not None else None,
            "sequence_number": obj.get("sequence_number")
        })
        return _obj


