# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.collider import Collider
from wandelbots_api_client.v2.models.collision_motion_group import CollisionMotionGroup
from wandelbots_api_client.v2.models.pose import Pose
from wandelbots_api_client.v2.models.robot_setup import RobotSetup
from typing import Optional, Set
from typing_extensions import Self

class InverseKinematicsRequest(BaseModel):
    """
    InverseKinematicsRequest
    """ # noqa: E501
    robot_setup: RobotSetup = Field(description="The data to assemble the robot setup can be retrieved from [getPlanningParameters](getPlanningParameters) endpoint.")
    tcp_poses: List[Pose] = Field(description="List of TCP poses for which the inverse solutions are computed. ")
    static_colliders: Optional[Dict[str, Collider]] = Field(default=None, description="A collection of identifiable colliders.")
    collision_motion_group: Optional[CollisionMotionGroup] = Field(default=None, description="Collision motion group. ")
    __properties: ClassVar[List[str]] = ["robot_setup", "tcp_poses", "static_colliders", "collision_motion_group"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InverseKinematicsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of robot_setup
        if self.robot_setup:
            _dict['robot_setup'] = self.robot_setup.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tcp_poses (list)
        _items = []
        if self.tcp_poses:
            for _item in self.tcp_poses:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['tcp_poses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in static_colliders (dict)
        _field_dict = {}
        if self.static_colliders:
            for _key in self.static_colliders:
                if self.static_colliders[_key]:
                    _field_dict[_key] = self.static_colliders[_key].to_dict()
            _dict['static_colliders'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of collision_motion_group
        if self.collision_motion_group:
            _dict['collision_motion_group'] = self.collision_motion_group.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InverseKinematicsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "robot_setup": RobotSetup.from_dict(obj["robot_setup"]) if obj.get("robot_setup") is not None else None,
            "tcp_poses": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                Pose.from_dict(_item) if hasattr(Pose, 'from_dict') else _item
                # <<< End modification
                for _item in obj["tcp_poses"]
            ] if obj.get("tcp_poses") is not None else None,
            "static_colliders": dict(
                (_k, Collider.from_dict(_v))
                for _k, _v in obj["static_colliders"].items()
            )
            if obj.get("static_colliders") is not None
            else None,
            "collision_motion_group": CollisionMotionGroup.from_dict(obj["collision_motion_group"]) if obj.get("collision_motion_group") is not None else None
        })
        return _obj


