# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.io_description_min import IODescriptionMin
from wandelbots_api_client.v2.models.io_direction import IODirection
from wandelbots_api_client.v2.models.io_value_type import IOValueType
from wandelbots_api_client.v2.models.unit_type import UnitType
from typing import Optional, Set
from typing_extensions import Self

class IODescription(BaseModel):
    """
    IODescription
    """ # noqa: E501
    io: StrictStr = Field(description="Unique identifier defined by the controller. Identifiers are only defined uniquely per controller, e.g. Inputs/Outputs for two different robots on the same controller can have the same identifier. ")
    name: StrictStr = Field(description="Name of the input/output. Customize it on the physical controller or in the virtual robot specification. ")
    group: Optional[StrictStr] = Field(default=None, description="Name of the input/output group. Customize it on the physical controller or in the virtual robot specification. ")
    direction: IODirection
    value_type: IOValueType
    unit: Optional[UnitType] = None
    min: Optional[IODescriptionMin] = None
    max: Optional[IODescriptionMin] = None
    __properties: ClassVar[List[str]] = ["io", "name", "group", "direction", "value_type", "unit", "min", "max"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IODescription from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of min
        if self.min:
            _dict['min'] = self.min.to_dict()
        # override the default output from pydantic by calling `to_dict()` of max
        if self.max:
            _dict['max'] = self.max.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IODescription from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "io": obj.get("io"),
            "name": obj.get("name"),
            "group": obj.get("group"),
            "direction": obj.get("direction"),
            "value_type": obj.get("value_type"),
            "unit": obj.get("unit"),
            "min": IODescriptionMin.from_dict(obj["min"]) if obj.get("min") is not None else None,
            "max": IODescriptionMin.from_dict(obj["max"]) if obj.get("max") is not None else None
        })
        return _obj


