# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.joints import Joints
from wandelbots_api_client.v2.models.motion_group_state_joint_limit_reached import MotionGroupStateJointLimitReached
from wandelbots_api_client.v2.models.motion_vector import MotionVector
from wandelbots_api_client.v2.models.pose import Pose
from typing import Optional, Set
from typing_extensions import Self

class MotionGroupState(BaseModel):
    """
    MotionGroupState
    """ # noqa: E501
    timestamp: Optional[datetime] = Field(default=None, description="Timestamp indicating when the represented information was received from the robot controller.")
    sequence_number: StrictInt = Field(description="Sequence number of the controller state. It starts with 0 upon establishing the connection with a physical controller. The sequence number is reset when the connection to the physical controller is closed and re-established. ")
    motion_group: StrictStr = Field(description="Identifier of the motion group.")
    controller: StrictStr = Field(description="Convenience: Identifier of the robot controller the motion group is attached to.")
    joint_position: Joints = Field(description="Current joint position of each joint in [rad] ")
    joint_limit_reached: MotionGroupStateJointLimitReached = Field(description="Indicates whether the joint is in a limit for all joints of the motion group. ")
    joint_velocity: Joints = Field(description="Current joint velocity of each joint in [rad/s] ")
    joint_torque: Optional[Joints] = Field(default=None, description="Current joint torque of each joint in [Nm]. Is only available if the robot controller supports it (e.g. available for UR Controllers). ")
    joint_current: Optional[Joints] = Field(default=None, description="Current Current at TCP in [A]. Is only available if the robot controller supports it, e.g. available for UR Controllers. ")
    flange_pose: Optional[Pose] = Field(default=None, description="Pose of the Flange (last point of the motion group before the endeffector starts). Positions are in [mm]. Oriantations are in [rad]. The pose is relative to the response_coordinate_system that is specified in the request. For robot arms a flange pose is always returned, for positioners the flange might not be available, depending on the model. ")
    tcp: StrictStr = Field(description="Unique identifier addressing the TCP currently set. ")
    tcp_pose: Pose = Field(description="Pose of the TCP currently selected on the robot control panel. Positions are in [mm]. Oriantations are in [rad]. The pose is relative to the response_coordinate_system that is specified in the request. ")
    tcp_velocity: MotionVector = Field(description="Current velocity at TCP in [mm/s]. If `tcp` is not specified, the velocity at the flange is returned. The velocity is relative to the response_coordinate_system specified in the request. ")
    coordinate_system: StrictStr = Field(description="Unique identifier addressing the reference coordinate system of the cartesian data. Default is the world coordinate system of corresponding controller. ")
    payload: Optional[StrictStr] = Field(default=None, description="Unique identifier addressing the Payload currently set. Only fetchable via GET endpoint, not available in WebSocket. ")
    __properties: ClassVar[List[str]] = ["timestamp", "sequence_number", "motion_group", "controller", "joint_position", "joint_limit_reached", "joint_velocity", "joint_torque", "joint_current", "flange_pose", "tcp", "tcp_pose", "tcp_velocity", "coordinate_system", "payload"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MotionGroupState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of joint_position
        if self.joint_position:
            _dict['joint_position'] = self.joint_position.to_dict()
        # override the default output from pydantic by calling `to_dict()` of joint_limit_reached
        if self.joint_limit_reached:
            _dict['joint_limit_reached'] = self.joint_limit_reached.to_dict()
        # override the default output from pydantic by calling `to_dict()` of joint_velocity
        if self.joint_velocity:
            _dict['joint_velocity'] = self.joint_velocity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of joint_torque
        if self.joint_torque:
            _dict['joint_torque'] = self.joint_torque.to_dict()
        # override the default output from pydantic by calling `to_dict()` of joint_current
        if self.joint_current:
            _dict['joint_current'] = self.joint_current.to_dict()
        # override the default output from pydantic by calling `to_dict()` of flange_pose
        if self.flange_pose:
            _dict['flange_pose'] = self.flange_pose.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tcp_pose
        if self.tcp_pose:
            _dict['tcp_pose'] = self.tcp_pose.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tcp_velocity
        if self.tcp_velocity:
            _dict['tcp_velocity'] = self.tcp_velocity.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MotionGroupState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "timestamp": obj.get("timestamp"),
            "sequence_number": obj.get("sequence_number"),
            "motion_group": obj.get("motion_group"),
            "controller": obj.get("controller"),
            "joint_position": Joints.from_dict(obj["joint_position"]) if obj.get("joint_position") is not None else None,
            "joint_limit_reached": MotionGroupStateJointLimitReached.from_dict(obj["joint_limit_reached"]) if obj.get("joint_limit_reached") is not None else None,
            "joint_velocity": Joints.from_dict(obj["joint_velocity"]) if obj.get("joint_velocity") is not None else None,
            "joint_torque": Joints.from_dict(obj["joint_torque"]) if obj.get("joint_torque") is not None else None,
            "joint_current": Joints.from_dict(obj["joint_current"]) if obj.get("joint_current") is not None else None,
            "flange_pose": Pose.from_dict(obj["flange_pose"]) if obj.get("flange_pose") is not None else None,
            "tcp": obj.get("tcp"),
            "tcp_pose": Pose.from_dict(obj["tcp_pose"]) if obj.get("tcp_pose") is not None else None,
            "tcp_velocity": MotionVector.from_dict(obj["tcp_velocity"]) if obj.get("tcp_velocity") is not None else None,
            "coordinate_system": obj.get("coordinate_system"),
            "payload": obj.get("payload")
        })
        return _obj


